/*
 * Decompiled with CFR 0.152.
 */
package ch.tatool.app.service.impl;

import ch.tatool.app.data.ModuleImpl;
import ch.tatool.data.Module;
import ch.tatool.data.ModuleSession;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;

public class ModuleSessionDAO {
    private SessionFactory sessionFactory;

    public List<ModuleSession> getSessions(ModuleImpl module) {
        String queryString = "select session from ModuleSessionImpl session where session.module = :module order by session.id";
        Query query = this.sessionFactory.getCurrentSession().createQuery(queryString);
        query.setParameter("module", (Object)module);
        List result = query.list();
        for (ModuleSession s : result) {
            s.setModule((Module)module);
        }
        return result;
    }

    private Integer findLastSessionIndex(ModuleImpl module) {
        String queryString = "select max(session.index) from ModuleSessionImpl session where session.module = :module";
        Query query = this.sessionFactory.getCurrentSession().createQuery(queryString);
        query.setParameter("module", (Object)module);
        Integer result = (Integer)query.uniqueResult();
        if (result != null) {
            return result;
        }
        return 0;
    }

    public void saveSession(ModuleImpl module, ModuleSession session) {
        if (session.getId() == null) {
            session.setModule((Module)module);
            session.setIndex(this.findLastSessionIndex(module) + 1);
            this.sessionFactory.getCurrentSession().save((Object)session);
        } else {
            this.sessionFactory.getCurrentSession().update((Object)session);
        }
    }

    public void deleteSession(ModuleImpl module, ModuleSession session) {
        this.sessionFactory.getCurrentSession().delete((Object)session);
    }

    public ModuleSession findLastSession(ModuleImpl module, boolean includeUnfinished) {
        Criteria criteria = this.sessionFactory.getCurrentSession().createCriteria(ModuleSession.class);
        criteria.add((Criterion)Restrictions.eq((String)"module", (Object)module));
        if (!includeUnfinished) {
            criteria.add((Criterion)Restrictions.eq((String)"completed", (Object)1));
        }
        criteria.setFetchSize(1);
        criteria.addOrder(Order.desc((String)"id"));
        List sessions = criteria.list();
        if (sessions.size() > 0) {
            return (ModuleSession)sessions.get(0);
        }
        return null;
    }

    public Long getSessionCount(ModuleImpl module, boolean includeUnfinished) {
        String query = "select count(session) from ModuleSessionImpl session where session.module = :module";
        if (!includeUnfinished) {
            query = query + " and session.completed = 1";
        }
        return (Long)this.sessionFactory.getCurrentSession().createQuery(query).setParameter("module", (Object)module).uniqueResult();
    }

    public List<Object[]> findDistinctSessionPropertyNames(ModuleImpl module) {
        StringBuilder queryString = new StringBuilder();
        queryString.append("Select distinct(entry.nodeId), entry.name").append(" from ModuleSessionImpl session left join session.entriesImpl entry").append(" where session.module = :module").append(" and entry.nodeId is not NULL").append(" order by entry.nodeId, entry.name");
        Query query = this.sessionFactory.getCurrentSession().createQuery(queryString.toString());
        query.setParameter("module", (Object)module);
        return query.list();
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }
}

