/*******************************************************************************
 * Copyright (c) 2011 Michael Ruflin, Andr Locher, Claudia von Bastian.
 * 
 * This file is part of Tatool.
 * 
 * Tatool is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published 
 * by the Free Software Foundation, either version 3 of the License, or 
 * (at your option) any later version.
 * 
 * Tatool is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with Tatool. If not, see <http://www.gnu.org/licenses/>.
 ******************************************************************************/
package ch.tatool.app.service.impl;

import java.util.Random;

import org.apache.commons.dbcp.BasicDataSource;
import org.hibernate.SQLQuery;
import org.hibernate.SessionFactory;
import org.springframework.orm.hibernate3.SessionFactoryUtils;

import ch.tatool.app.data.UserAccountImpl;

/**
 * Property access object for user account objects.
 * 
 * @author Michael Ruflin
 */
public class UserAccountDAO {

	private SessionFactory sessionFactory;

	/**
	 * Loads an account object from the database, using the id specified in the
	 * account.
	 * 
	 * If no account with given id exists, a new one is created.
	 * 
	 * @param module
	 *            the module to load
	 */
	public void loadAccount(UserAccountImpl userAccount) {
		if (userAccount.getId() != null) {
			sessionFactory.getCurrentSession().load(userAccount, userAccount.getId());
		} else {
			// create a random id
			Long id = new Random().nextLong();
			id = Math.abs(id);
			userAccount.setId(id);
			sessionFactory.getCurrentSession().save(userAccount);
		}
	}

	/**
	 * Stores a user account.
	 */
	public void saveAccount(UserAccountImpl account) {
		sessionFactory.getCurrentSession().saveOrUpdate(account);
	}

	/**
	 * Deletes a user account.
	 */
	public void deleteAccount(UserAccountImpl account) {
		sessionFactory.getCurrentSession().delete(account);
	}

	public void setAccountPassword(final UserAccountImpl account, final String password) {
		BasicDataSource dataSource = (BasicDataSource) SessionFactoryUtils.getDataSource(sessionFactory);
		String username = dataSource.getUsername();
		String newPassword = password != null ? password : "";
		
		StringBuilder sql = new StringBuilder();
		sql.append("ALTER USER '").append(username)
				.append("' SET PASSWORD '").append(newPassword)
				.append("'");

		SQLQuery query = sessionFactory.getCurrentSession().createSQLQuery(sql.toString());
		query.executeUpdate();
		
		dataSource.setPassword(newPassword);
		account.setPassword(newPassword);
		account.setPasswordProtected(!newPassword.isEmpty());
	}

	public void shutdown() {
		String sql = "SHUTDOWN";
		SQLQuery query = sessionFactory.getCurrentSession().createSQLQuery(sql);
		query.executeUpdate();
	}

	public void setSessionFactory(SessionFactory sessionFactory) {
		this.sessionFactory = sessionFactory;
	}
}
