/*
 * Decompiled with CFR 0.152.
 */
package ch.tbmelabs.actuatorendpointssecurityutils.configuration;

import ch.tbmelabs.actuatorendpointssecurityutils.configuration.ApplicationProperties;
import javax.annotation.PostConstruct;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.config.annotation.ObjectPostProcessor;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.authentication.configurers.provisioning.InMemoryUserDetailsManagerConfigurer;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.util.Assert;

@Order(value=2)
@Configuration
@EnableWebSecurity
public class ActuatorEndpointSecurityConfiguration
extends WebSecurityConfigurerAdapter {
    private static final BCryptPasswordEncoder PASSWORD_ENCODER = new BCryptPasswordEncoder();
    private ObjectPostProcessor<Object> objectPostProcessor;
    private String actuatorUserName;
    private String actuatorUserPassword;
    private String actuatorUserRole;

    public ActuatorEndpointSecurityConfiguration(ObjectPostProcessor<Object> objectPostProcessor, ApplicationProperties applicationProperties) {
        this.objectPostProcessor = objectPostProcessor;
        this.actuatorUserName = applicationProperties.getEureka().getInstance().getMetadataMap().getUser().getName();
        this.actuatorUserPassword = applicationProperties.getEureka().getInstance().getMetadataMap().getUser().getPassword();
        this.actuatorUserRole = applicationProperties.getEureka().getInstance().getMetadataMap().getUser().getRole();
    }

    @PostConstruct
    public void postConstruct() {
        Assert.notNull((Object)this.actuatorUserName, (String)"You must specify an actuator user name!");
        Assert.notNull((Object)this.actuatorUserPassword, (String)"You must specify an actuator user password!");
        Assert.notNull((Object)this.actuatorUserRole, (String)"You must specify an actuator user role!");
    }

    protected AuthenticationManager authenticationManager() throws Exception {
        AuthenticationManagerBuilder builder = new AuthenticationManagerBuilder(this.objectPostProcessor);
        ((InMemoryUserDetailsManagerConfigurer)builder.inMemoryAuthentication().passwordEncoder((PasswordEncoder)PASSWORD_ENCODER)).withUser(this.actuatorUserName).password(PASSWORD_ENCODER.encode((CharSequence)this.actuatorUserPassword)).roles(new String[]{this.actuatorUserRole});
        return (AuthenticationManager)builder.build();
    }

    protected void configure(HttpSecurity http) throws Exception {
        ((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.antMatcher("/actuator/**").authorizeRequests().antMatchers(new String[]{"/actuator/**"})).hasRole(this.actuatorUserRole).and()).httpBasic();
    }
}

