/*
 * Decompiled with CFR 0.152.
 */
package ch.turic.analyzer;

import ch.turic.BadSyntax;
import ch.turic.ExecutionException;
import ch.turic.analyzer.ExpressionAnalyzer;
import ch.turic.analyzer.Lex;
import ch.turic.analyzer.LexList;
import ch.turic.commands.Command;
import ch.turic.commands.TypeDeclaration;
import java.util.ArrayList;

public class AssignmentList {
    public static final AssignmentList INSTANCE = new AssignmentList();
    public static final TypeDeclaration[] EMPTY_TYPE = new TypeDeclaration[0];

    public Assignment[] analyze(LexList lexes) throws BadSyntax {
        return this.analyze(lexes, true);
    }

    public Assignment[] analyze(LexList lexes, boolean addValues) throws BadSyntax {
        ArrayList<Assignment> pairs = new ArrayList<Assignment>();
        while (lexes.peek().type() == Lex.Type.IDENTIFIER) {
            Command expression;
            TypeDeclaration[] type;
            Lex identifier = lexes.next();
            if (lexes.is(":")) {
                lexes.next();
                type = AssignmentList.getTheTypeDefinitions(lexes);
            } else {
                type = EMPTY_TYPE;
            }
            if (lexes.is("=") && addValues) {
                lexes.next();
                expression = ExpressionAnalyzer.INSTANCE.analyze(lexes);
            } else {
                expression = null;
            }
            pairs.add(new Assignment(identifier.text(), type, expression));
            if (!lexes.is(",")) break;
            lexes.next();
            BadSyntax.when(lexes, !lexes.isIdentifier(), "Identifier missing after , ", new Object[0]);
        }
        return (Assignment[])pairs.toArray(Assignment[]::new);
    }

    public static TypeDeclaration[] getTheTypeDefinitions(LexList lexes) {
        ArrayList<TypeDeclaration> types = new ArrayList<TypeDeclaration>();
        AssignmentList.fetchNextType(lexes, types);
        while (lexes.is("|")) {
            lexes.next();
            AssignmentList.fetchNextType(lexes, types);
        }
        return (TypeDeclaration[])types.toArray(TypeDeclaration[]::new);
    }

    public static TypeDeclaration[] getTheTypeDefinitionsClosureArgs(LexList lexes) {
        ArrayList<TypeDeclaration> types = new ArrayList<TypeDeclaration>();
        AssignmentList.fetchNextType(lexes, types);
        while (lexes.is("|") && (lexes.isAt(1, Lex.Type.IDENTIFIER) && lexes.isAt(2, "|", ",", "=") || lexes.isAt(1, "("))) {
            lexes.next();
            AssignmentList.fetchNextType(lexes, types);
        }
        return (TypeDeclaration[])types.toArray(TypeDeclaration[]::new);
    }

    public static void fetchNextType(LexList lexes, ArrayList<TypeDeclaration> type) {
        boolean referenced = lexes.is("(");
        if (referenced) {
            lexes.next();
            Command expression = ExpressionAnalyzer.INSTANCE.analyze(lexes);
            ExecutionException.when(lexes.isNot(")"), "Type expression starting with '(' must finish with ')'", new Object[0]);
            lexes.next();
            type.add(new TypeDeclaration(null, expression));
        } else {
            ExecutionException.when(!lexes.isIdentifier() && !lexes.isKeyword(), "following the ':' and '|' a type identifier has to follow", new Object[0]);
            type.add(new TypeDeclaration(lexes.next().text(), null));
        }
    }

    public record Assignment(String identifier, TypeDeclaration[] types, Command expression) {
    }
}

