/*
 * Decompiled with CFR 0.152.
 */
package ch.turic.analyzer;

import ch.turic.BadSyntax;
import ch.turic.analyzer.AbstractAnalyzer;
import ch.turic.analyzer.Analyzer;
import ch.turic.analyzer.AssignmentList;
import ch.turic.analyzer.BlockAnalyzer;
import ch.turic.analyzer.CommandAnalyzer;
import ch.turic.analyzer.ExpressionAnalyzer;
import ch.turic.analyzer.ForEachLoopAnalyzer;
import ch.turic.analyzer.LexList;
import ch.turic.commands.Assignment;
import ch.turic.commands.Command;
import ch.turic.commands.ConstantExpression;
import ch.turic.commands.ForLoop;
import ch.turic.commands.LetAssignment;
import ch.turic.memory.LeftValue;
import ch.turic.memory.VariableLeftValue;

public class ForLoopAnalyzer
extends AbstractAnalyzer {
    public static final ForLoopAnalyzer INSTANCE = new ForLoopAnalyzer();

    @Override
    public Command _analyze(LexList lexes) throws BadSyntax {
        boolean resultList;
        Command loopCondition;
        if (lexes.is("each")) {
            lexes.next();
            return ForEachLoopAnalyzer.INSTANCE.analyze(lexes);
        }
        boolean withParentheses = lexes.is("(");
        if (withParentheses) {
            lexes.next();
        }
        Command startCommand = this.getInitialAssignmentCommand(lexes);
        if (lexes.is(";")) {
            loopCondition = new ConstantExpression(true);
            lexes.next();
        } else {
            loopCondition = ExpressionAnalyzer.INSTANCE.analyze(lexes);
            if (lexes.is(";")) {
                lexes.next();
            }
        }
        Command stepCommand = lexes.is(":", "{", "list") ? null : CommandAnalyzer.INSTANCE.analyze(lexes);
        ForLoopAnalyzer.checkClosingParen(lexes, withParentheses);
        if (lexes.is("list")) {
            resultList = true;
            lexes.next();
        } else {
            resultList = false;
        }
        Command body = ForLoopAnalyzer.getLoopBody(lexes);
        Command exitCondition = ForLoopAnalyzer.getOptionalExistCondition(lexes);
        return new ForLoop(startCommand, loopCondition, exitCondition, stepCommand, resultList, body);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Command getInitialAssignmentCommand(LexList lexes) throws BadSyntax {
        String variable;
        Assignment assignment;
        LeftValue leftValue;
        Command startCommand = CommandAnalyzer.INSTANCE.analyze(lexes);
        if (!(startCommand instanceof Assignment) || !((leftValue = (assignment = (Assignment)startCommand).leftValue()) instanceof VariableLeftValue)) return startCommand;
        VariableLeftValue variableLeftValue = (VariableLeftValue)leftValue;
        try {
            String string;
            variable = string = variableLeftValue.variable();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        return new LetAssignment(new AssignmentList.Assignment[]{new AssignmentList.Assignment(variable, null, assignment.expression())}, true);
    }

    static void checkClosingParen(LexList lexes, boolean withParentheses) throws BadSyntax {
        if (withParentheses) {
            BadSyntax.when(lexes, lexes.isNot(")"), "You have to close the parentheses in the 'for' or 'while' loop and 'with'", new Object[0]);
            lexes.next();
        } else {
            BadSyntax.when(lexes, lexes.isNot(":", "{", "list"), "'for' or 'while' loop and 'with' body has to be after '{' or ':'", new Object[0]);
        }
    }

    static Command getOptionalExistCondition(LexList lexes) throws BadSyntax {
        Command exitCondition;
        if (lexes.is("until")) {
            lexes.next();
            exitCondition = ExpressionAnalyzer.INSTANCE.analyze(lexes);
            Analyzer.checkCommandTermination(lexes);
        } else {
            exitCondition = new ConstantExpression(false);
        }
        return exitCondition;
    }

    static Command getLoopBody(LexList lexes) throws BadSyntax {
        Command body;
        if (lexes.is(":")) {
            lexes.next();
            body = CommandAnalyzer.INSTANCE.analyze(lexes);
        } else if (lexes.is("{")) {
            body = BlockAnalyzer.INSTANCE.analyze(lexes);
        } else {
            throw lexes.syntaxError("Loop body must start with ':' or '{'.", new Object[0]);
        }
        return body;
    }
}

