/*
 * Decompiled with CFR 0.152.
 */
package ch.turic.analyzer;

import ch.turic.BadSyntax;
import ch.turic.analyzer.AbstractAnalyzer;
import ch.turic.analyzer.BlockAnalyzer;
import ch.turic.analyzer.CommandAnalyzer;
import ch.turic.analyzer.ExpressionAnalyzer;
import ch.turic.analyzer.LexList;
import ch.turic.commands.BlockCommand;
import ch.turic.commands.Command;
import ch.turic.commands.If;

public class IfAnalyzer
extends AbstractAnalyzer {
    public static final IfAnalyzer INSTANCE = new IfAnalyzer();

    @Override
    public If _analyze(LexList lexes) throws BadSyntax {
        Command thenBlock;
        Command condition = ExpressionAnalyzer.INSTANCE.analyze(lexes);
        if (lexes.is("{")) {
            thenBlock = BlockAnalyzer.INSTANCE.analyze(lexes);
        } else if (lexes.is(":")) {
            lexes.next();
            Command t = CommandAnalyzer.INSTANCE.analyze(lexes);
            BadSyntax.when(lexes, t == null, "Empty command ( ';' ) must not be after 'if expression' or 'elseif expression'", new Object[0]);
            thenBlock = t;
        } else {
            throw lexes.syntaxError(": or {", "Expected ':' or '{' after if condition");
        }
        if (lexes.is("elseif")) {
            return new If(condition, thenBlock, INSTANCE.analyze(lexes));
        }
        if (lexes.is("else")) {
            Command elseBlock;
            lexes.next();
            if (lexes.is("if")) {
                return new If(condition, thenBlock, INSTANCE.analyze(lexes));
            }
            if (lexes.is("{")) {
                elseBlock = BlockAnalyzer.INSTANCE.analyze(lexes);
            } else if (lexes.is(":")) {
                lexes.next();
                Command t = CommandAnalyzer.INSTANCE.analyze(lexes);
                BadSyntax.when(lexes, t == null, "Empty command ( ';' ) must not be after 'else expression'", new Object[0]);
                elseBlock = new BlockCommand(new Command[]{t}, true);
            } else {
                throw lexes.syntaxError(": or {", "Expected '{' after if condition");
            }
            return new If(condition, thenBlock, elseBlock);
        }
        return new If(condition, thenBlock, null);
    }
}

