/*
 * Decompiled with CFR 0.152.
 */
package ch.turic.analyzer;

import ch.turic.BadSyntax;
import ch.turic.analyzer.BlockAnalyzer;
import ch.turic.analyzer.ClosureAnalyzer;
import ch.turic.analyzer.ExpressionAnalyzer;
import ch.turic.analyzer.Lex;
import ch.turic.analyzer.LexList;
import ch.turic.commands.Command;
import ch.turic.memory.ArrayElementLeftValue;
import ch.turic.memory.CalculatedLeftValue;
import ch.turic.memory.LeftValue;
import ch.turic.memory.ObjectFieldLeftValue;
import ch.turic.memory.VariableLeftValue;

public class LeftValueAnalyzer {
    public static final LeftValueAnalyzer INSTANCE = new LeftValueAnalyzer();

    public LeftValue analyze(LexList lexes) throws BadSyntax {
        if (lexes.isEmpty()) {
            return null;
        }
        Lex lex = lexes.peek();
        if (lex.type() == Lex.Type.IDENTIFIER) {
            VariableLeftValue left = new VariableLeftValue(lex.text());
            lexes.next();
            return this.getLeftValueTail(lexes, left);
        }
        if (!(!lex.text.equals("{") || ClosureAnalyzer.blockStartsClosure(lexes) || (lexes.isAt(1, Lex.Type.IDENTIFIER) || lexes.isAt(1, Lex.Type.STRING)) && lexes.isAt(2, ":"))) {
            CalculatedLeftValue left = new CalculatedLeftValue(BlockAnalyzer.INSTANCE.analyze(lexes));
            if (lexes.isNot(".", "[")) {
                return null;
            }
            return this.getLeftValueTail(lexes, left);
        }
        return null;
    }

    private LeftValue getLeftValueTail(LexList lexes, LeftValue left) {
        while (lexes.is(".") || lexes.is("[")) {
            switch (lexes.peek().text()) {
                case ".": {
                    lexes.next();
                    Lex fieldName = lexes.next();
                    BadSyntax.when(lexes, fieldName.type() != Lex.Type.IDENTIFIER, "Field name is invalid", new Object[0]);
                    left = new ObjectFieldLeftValue(left, fieldName.text());
                    break;
                }
                case "[": {
                    lexes.next();
                    Command indexExpression = ExpressionAnalyzer.INSTANCE.analyze(lexes);
                    lexes.next(Lex.Type.RESERVED, "]", "Array access needs ] at the end.");
                    left = new ArrayElementLeftValue(left, indexExpression);
                }
            }
        }
        return left;
    }
}

