/*
 * Decompiled with CFR 0.152.
 */
package ch.turic.analyzer;

import ch.turic.BadSyntax;
import ch.turic.analyzer.BinaryExpressionAnalyzer;
import ch.turic.analyzer.Input;
import ch.turic.analyzer.Lex;
import ch.turic.analyzer.LexList;
import ch.turic.analyzer.Pos;
import ch.turic.analyzer.StringFetcher;
import ch.turic.analyzer.UnaryExpressionAnalyzer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class Lexer {
    private static final Set<String> RESERVED = new HashSet<String>(Set.of("class", "pin", "fn", "let", "global", "if", "else", "elseif", "die", "break", "continue", "while", "with", "until", "for", "flow", "each", "list", "in", "return", "yield", "when", "try", "catch", "finally", "async", "await", "as", "print", "println", "mut"));
    private static final ArrayList<String> _OPERANDS = new ArrayList<String>(Arrays.asList("--", "++", "->", "<-", "=", "(", ")", ",", ".", ".?", "&{", "{", "}", "[", "]", ";", ":", "|", "?", "@", "^", "#"));
    private static final String[] OPERANDS;
    private static final String[] uniKeys;
    private static final String[] uniSymbols;

    private static String getUnicodeKeyword(String ch) {
        for (int i = 0; i < uniKeys.length; i += 2) {
            if (!ch.equals(uniKeys[i])) continue;
            return uniKeys[i + 1];
        }
        return null;
    }

    private static String getUnicodeSymbol(String ch) {
        for (int i = 0; i < uniSymbols.length; i += 2) {
            if (!ch.equals(uniSymbols[i])) continue;
            return uniSymbols[i + 1];
        }
        return null;
    }

    public static LexList analyze(Input in) throws BadSyntax {
        ArrayList<Lex> list = new ArrayList<Lex>();
        if (in.startsWith("#!") == 0) {
            while (!in.isEmpty() && in.charAt(0) != '\n') {
                in.skip(1);
            }
        }
        while (!in.isEmpty()) {
            Lex lex;
            CharSequence str;
            Pos position = in.position;
            boolean atLineStart = false;
            while (!(in.isEmpty() || in.charAt(0) != '\n' && in.charAt(0) != '\r')) {
                atLineStart = true;
                in.skip(1);
            }
            while (!in.isEmpty() && Character.isWhitespace(in.charAt(0))) {
                in.skip(1);
            }
            if (in.isEmpty()) break;
            if (in.length() >= 2 && in.charAt(0) == '/' && in.charAt(1) == '*') {
                in.skip(2);
                Lexer.skipMLComment(in);
                continue;
            }
            if (in.length() >= 2 && in.charAt(0) == '/' && in.charAt(1) == '/') {
                Lexer.skipComment(in);
                continue;
            }
            if (in.charAt(0) == '`') {
                String id = StringFetcher.fetchId(in);
                list.add(new Lex(Lex.Type.IDENTIFIER, id, atLineStart, position));
                continue;
            }
            String uniKeyword = Lexer.getUnicodeKeyword("" + in.charAt(0));
            if (uniKeyword != null) {
                if (RESERVED.contains(uniKeyword)) {
                    list.add(new Lex(Lex.Type.RESERVED, uniKeyword, atLineStart, position));
                } else {
                    list.add(new Lex(Lex.Type.IDENTIFIER, uniKeyword, atLineStart, position));
                }
                in.skip(1);
                continue;
            }
            if (Input.validId1stChar(in.charAt(0))) {
                String id = in.fetchId();
                if (RESERVED.contains(id)) {
                    list.add(new Lex(Lex.Type.RESERVED, id, atLineStart, position));
                    continue;
                }
                list.add(new Lex(Lex.Type.IDENTIFIER, id, atLineStart, position));
                continue;
            }
            if (in.charAt(0) == '$' && in.length() >= 2 && in.charAt(1) == '\"') {
                in.skip(1);
                str = StringFetcher.getString(in);
                Lex lex2 = new Lex(Lex.Type.STRING, (String)str, atLineStart, position, true);
                list.add(lex2);
                continue;
            }
            if (in.charAt(0) == '\"') {
                str = StringFetcher.getString(in);
                Lex lex3 = new Lex(Lex.Type.STRING, (String)str, atLineStart, position, false);
                list.add(lex3);
                continue;
            }
            if (in.length() > 2 && in.charAt(0) == '0' && (in.charAt(1) == 'x' || in.charAt(1) == 'X')) {
                str = new StringBuilder(in.substring(0, 2));
                in.skip(2);
                ((StringBuilder)str).append(in.fetchHexNumber());
                Lex lex4 = new Lex(Lex.Type.INTEGER, ((StringBuilder)str).toString(), atLineStart, position);
                list.add(lex4);
                continue;
            }
            if (Character.isDigit(in.charAt(0))) {
                Lex.Type type;
                str = new StringBuilder();
                ((StringBuilder)str).append(in.fetchNumber());
                if (in.length() >= 2 && in.charAt(0) == '.' && Character.isDigit(in.charAt(1)) || !in.isEmpty() && (in.charAt(0) == 'e' || in.charAt(0) == 'E')) {
                    if (in.charAt(0) == '.') {
                        ((StringBuilder)str).append('.');
                        in.skip(1);
                        ((StringBuilder)str).append(in.fetchNumber());
                    }
                    if (!(in.isEmpty() || in.charAt(0) != 'e' && in.charAt(0) != 'E')) {
                        ((StringBuilder)str).append('e');
                        in.skip(1);
                        if (!(in.isEmpty() || in.charAt(0) != '+' && in.charAt(0) != '-')) {
                            ((StringBuilder)str).append(in.charAt(0));
                            in.skip(1);
                        }
                        ((StringBuilder)str).append(in.fetchNumber());
                    }
                    type = Lex.Type.FLOAT;
                } else {
                    type = Lex.Type.INTEGER;
                }
                lex = new Lex(type, ((StringBuilder)str).toString(), atLineStart, position);
                list.add(lex);
                continue;
            }
            String uniSym = Lexer.getUnicodeSymbol("" + in.charAt(0));
            if (uniSym != null) {
                Lex lex5 = new Lex(Lex.Type.RESERVED, uniSym, atLineStart, position);
                list.add(lex5);
                in.skip(1);
                continue;
            }
            int operandIndex = in.startsWith(OPERANDS);
            if (operandIndex >= 0) {
                lex = new Lex(Lex.Type.RESERVED, OPERANDS[operandIndex], atLineStart, position);
                list.add(lex);
                in.skip(OPERANDS[operandIndex].length());
                continue;
            }
            throw new BadSyntax(in.position, "Unexpected character '" + in.charAt(0) + "' in the input", new Object[0]);
        }
        return new LexList(list);
    }

    private static void skipMLComment(Input in) {
        while (in.length() >= 2 && (in.charAt(0) != '*' || in.charAt(1) != '/')) {
            if (in.charAt(0) == '/' && in.charAt(1) == '*') {
                in.skip(2);
                Lexer.skipMLComment(in);
                continue;
            }
            in.skip(1);
        }
        if (!in.isEmpty()) {
            in.skip(1);
        }
        if (!in.isEmpty()) {
            in.skip(1);
        }
    }

    private static void skipComment(Input in) {
        while (!in.isEmpty() && in.charAt(0) != '\n') {
            in.skip(1);
        }
    }

    static {
        Arrays.stream(BinaryExpressionAnalyzer.binaryOperators).flatMap(Arrays::stream).forEach(s -> {
            if (Character.isAlphabetic(s.charAt(0))) {
                RESERVED.add((String)s);
            } else {
                _OPERANDS.add((String)s);
            }
        });
        Arrays.stream(UnaryExpressionAnalyzer.unaryOperators).forEach(s -> {
            if (Character.isAlphabetic(s.charAt(0))) {
                RESERVED.add((String)s);
            } else {
                _OPERANDS.add((String)s);
            }
        });
        _OPERANDS.sort((a, b) -> Integer.compare(b.length(), a.length()));
        OPERANDS = (String[])_OPERANDS.toArray(String[]::new);
        uniKeys = new String[]{"\u221e", "inf", "\u2205", "none", "\u2208", "in", "\u21f6", "async", "\u23f3", "await"};
        uniSymbols = new String[]{"\u2026", "..", "\u2192", "->", "\u2260", "!=", "\u2265", "<=", "\u2264", ">="};
    }
}

