/*
 * Decompiled with CFR 0.152.
 */
package ch.turic.builtins.functions;

import ch.turic.Context;
import ch.turic.ExecutionException;
import ch.turic.Interpreter;
import ch.turic.TuriFunction;
import ch.turic.builtins.functions.FunUtils;
import ch.turic.memory.LngObject;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;

public class Import
implements TuriFunction {
    public static final String APPIA = "APPIA";
    private final List<Path> appiaRoots = Import.getAppiaRoots();

    @Override
    public String name() {
        return "import";
    }

    @Override
    public Object call(Context context, Object[] args) throws ExecutionException {
        ch.turic.memory.Context ctx = FunUtils.ctx(context);
        FunUtils.oneArg(this.name(), args);
        String arg = args[0].toString();
        Path sourceFile = this.locateSource(arg);
        try {
            String source = Files.readString(sourceFile, StandardCharsets.UTF_8);
            return Import.doImportExport(ctx, source);
        }
        catch (IOException e) {
            throw new ExecutionException("Cannot read the import file '%s'", sourceFile.toString());
        }
    }

    static Object doImportExport(ch.turic.memory.Context ctx, String source) {
        Interpreter interpreter = new Interpreter(source);
        interpreter.execute();
        ch.turic.memory.Context importedContext = (ch.turic.memory.Context)interpreter.getImportContext();
        for (String exported : importedContext.exporting()) {
            ctx.let0(exported, importedContext.get(exported));
        }
        return new LngObject(null, importedContext);
    }

    private Path locateSource(String arg) {
        Path relativePath = Path.of(arg.replace('.', File.separatorChar) + ".turi", new String[0]);
        Path sourceFile = null;
        for (Path root : this.appiaRoots) {
            Path candidate = root.resolve(relativePath);
            if (!Files.exists(candidate, new LinkOption[0])) continue;
            sourceFile = candidate;
            break;
        }
        if (sourceFile == null) {
            throw new ExecutionException("There is no import '%s' via APPIA", arg);
        }
        return sourceFile;
    }

    private static List<Path> getAppiaRoots() {
        String appia = System.getProperty(APPIA);
        if (appia == null) {
            System.getenv(APPIA);
        }
        if (appia == null) {
            appia = Import.loadFromEnvFile();
        }
        if (appia == null || appia.isBlank()) {
            return List.of();
        }
        return Arrays.stream(appia.split("\\|")).map(String::trim).filter(s -> !s.isEmpty()).map(x$0 -> Path.of(x$0, new String[0])).map(Path::normalize).map(Path::toAbsolutePath).toList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String loadFromEnvFile() {
        Path current = Path.of("", new String[0]).toAbsolutePath();
        while (current != null) {
            try {
                Path envPath = current.resolve(".env");
                if (!Files.exists(envPath, new LinkOption[0]) || !Files.isReadable(envPath)) continue;
                List<String> lines = Files.readAllLines(envPath, StandardCharsets.UTF_8);
                for (String line : lines) {
                    String trimmed = line.trim();
                    if (!trimmed.startsWith("APPIA=")) continue;
                    String string = trimmed.substring("APPIA=".length()).trim();
                    return string;
                }
            }
            catch (IOException iOException) {}
            continue;
            finally {
                current = current.getParent();
            }
        }
        return null;
    }
}

