/*
 * Decompiled with CFR 0.152.
 */
package ch.turic.builtins.functions;

import ch.turic.Context;
import ch.turic.ExecutionException;
import ch.turic.TuriFunction;
import java.lang.invoke.TypeDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;

public class JavaMethodCall
implements TuriFunction {
    @Override
    public String name() {
        return "java_call";
    }

    @Override
    public Object call(Context ctx, Object[] arguments) throws ExecutionException {
        if (arguments.length < 2) {
            throw new ExecutionException("Function %s needs at least 2 arguments.", this.name());
        }
        Object object = arguments[1];
        if (!(object instanceof String)) {
            throw new ExecutionException("Function %s needs a method name as a second argument.", this.name());
        }
        String methodName = (String)object;
        KlassAndObject klassAndObject = JavaMethodCall.getKlassAndObject(arguments);
        Class<?> klass = klassAndObject.klass();
        Object object2 = klassAndObject.object();
        for (Method method : klass.getMethods()) {
            if (!method.getName().equals(methodName) || method.isSynthetic() || (method.isVarArgs() ? method.getParameterCount() <= arguments.length - 2 : method.getParameterCount() != arguments.length - 2)) continue;
            int i = 2;
            if (method.isVarArgs()) {
                Class<?> pType;
                int j = 0;
                while (j < method.getParameterTypes().length - 1 && (pType = method.getParameterTypes()[j]).isAssignableFrom(arguments[i].getClass())) {
                    ++j;
                    ++i;
                }
                TypeDescriptor.OfField lastPType = method.getParameterTypes()[method.getParameterTypes().length - 1].arrayType();
                while (i < arguments.length && ((Class)lastPType).isAssignableFrom(arguments[i].getClass())) {
                    ++i;
                }
            } else {
                for (Class<?> pType : method.getParameterTypes()) {
                    if (!JavaMethodCall.isAssignable(pType, arguments[i])) break;
                    ++i;
                }
            }
            if (i != arguments.length) continue;
            try {
                Object[] args;
                if (method.isVarArgs()) {
                    args = new Object[method.getParameterCount()];
                    int k = 2;
                    int h = 0;
                    while (h < method.getParameterCount() - 1) {
                        args[h++] = arguments[k++];
                    }
                    Class<?> varargComponentType = method.getParameterTypes()[method.getParameterCount() - 1].getComponentType();
                    Object varargs = Array.newInstance(varargComponentType, arguments.length - k);
                    int v = 0;
                    while (k < arguments.length) {
                        Array.set(varargs, v, arguments[k]);
                        ++k;
                        ++v;
                    }
                    args[h] = varargs;
                    return method.invoke(object2, args);
                }
                args = Arrays.copyOfRange(arguments, 2, arguments.length);
                return method.invoke(object2, args);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new ExecutionException("Cannot invoke method '" + methodName + "'.", e);
            }
        }
        throw new ExecutionException("Cannot find method '" + methodName + "'.", new Object[0]);
    }

    private static boolean isAssignable(Class<?> parameterType, Object arg) {
        if (arg == null) {
            return !parameterType.isPrimitive();
        }
        Class<?> argClass = arg.getClass();
        if (parameterType.isPrimitive()) {
            return switch (parameterType.getName()) {
                case "boolean" -> {
                    if (argClass == Boolean.class) {
                        yield true;
                    }
                    yield false;
                }
                case "byte" -> {
                    if (argClass == Byte.class) {
                        yield true;
                    }
                    yield false;
                }
                case "char" -> {
                    if (argClass == Character.class) {
                        yield true;
                    }
                    yield false;
                }
                case "short" -> {
                    if (argClass == Short.class) {
                        yield true;
                    }
                    yield false;
                }
                case "int" -> {
                    if (argClass == Integer.class) {
                        yield true;
                    }
                    yield false;
                }
                case "long" -> {
                    if (argClass == Long.class) {
                        yield true;
                    }
                    yield false;
                }
                case "float" -> {
                    if (argClass == Float.class) {
                        yield true;
                    }
                    yield false;
                }
                case "double" -> {
                    if (argClass == Double.class) {
                        yield true;
                    }
                    yield false;
                }
                default -> false;
            };
        }
        return parameterType.isAssignableFrom(argClass);
    }

    static KlassAndObject getKlassAndObject(Object[] arguments) {
        Object object;
        Class<?> klass;
        Object object2 = arguments[0];
        if (object2 instanceof String) {
            String className = (String)object2;
            try {
                klass = Class.forName(className);
                object = null;
            }
            catch (ClassNotFoundException ex) {
                throw new ExecutionException("Cannot find class '" + className + "'.", ex);
            }
        } else {
            klass = arguments[0].getClass();
            object = arguments[0];
        }
        return new KlassAndObject(klass, object);
    }

    record KlassAndObject(Class<?> klass, Object object) {
    }
}

