/*
 * Decompiled with CFR 0.152.
 */
package ch.turic.builtins.functions;

import ch.turic.Context;
import ch.turic.ExecutionException;
import ch.turic.TuriFunction;
import ch.turic.builtins.functions.Import;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;

public class SysImport
implements TuriFunction {
    @Override
    public String name() {
        return "sys_import";
    }

    @Override
    public Object call(Context context, Object[] args) throws ExecutionException {
        Object object;
        block10: {
            if (!(context instanceof ch.turic.memory.Context)) {
                throw new ExecutionException("context must be a context of type ch.turic.memory.Context", new Object[0]);
            }
            ch.turic.memory.Context ctx = (ch.turic.memory.Context)context;
            ExecutionException.when(args.length != 1 || args[0] == null, "Built-in function %s needs exactly one argument", this.name());
            String sys_name = args[0].toString();
            String resourceName = sys_name.replace(".", "/") + ".turi";
            InputStream is = this.getClass().getClassLoader().getResourceAsStream(resourceName);
            try {
                if (is == null) {
                    throw new ExecutionException("Could not find sys import " + sys_name + " in " + resourceName, new Object[0]);
                }
                String source = new String(is.readAllBytes(), StandardCharsets.UTF_8);
                object = Import.doImportExport(ctx, source);
                if (is == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ExecutionException("Cannot read the sys import '%s'", sys_name);
                }
            }
            is.close();
        }
        return object;
    }
}

