/*
 * Decompiled with CFR 0.152.
 */
package ch.turic.builtins.functions;

import ch.turic.Context;
import ch.turic.ExecutionException;
import ch.turic.TuriFunction;
import ch.turic.builtins.functions.FunUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlFormat
implements TuriFunction {
    private static final PrintStream NULL_ERR = new PrintStream(new OutputStream(){

        @Override
        public void write(int b) {
        }
    });

    @Override
    public String name() {
        return "xml_format";
    }

    @Override
    public Object call(Context context, Object[] args) throws ExecutionException {
        ch.turic.memory.Context ctx = FunUtils.ctx(context);
        FunUtils.oneArg(this.name(), args);
        String input = String.valueOf(args[0]);
        PrintStream savedErr = System.err;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setValidating(false);
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(new InputSource(new StringReader(input)));
            System.setErr(NULL_ERR);
            String string = XmlFormat.formatDocument(doc, 4);
            return string;
        }
        catch (IOException | ParserConfigurationException | TransformerException | SAXException e) {
            throw new ExecutionException("There was an XML exception formatting XML", e);
        }
        finally {
            System.setErr(savedErr);
        }
    }

    public static String formatDocument(Document doc, int tabsize) throws TransformerException {
        Transformer tf = TransformerFactory.newInstance().newTransformer();
        tf.setOutputProperty("encoding", "UTF-8");
        tf.setOutputProperty("indent", "yes");
        tf.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "" + tabsize);
        StringWriter out = new StringWriter();
        XmlFormat.trimDocument(doc);
        tf.transform(new DOMSource(doc), new StreamResult(out));
        return ((Object)out).toString();
    }

    private static void trimDocument(Document doc) {
        Element root = doc.getDocumentElement();
        XmlFormat.trimNode(root);
    }

    private static void trimNode(Node node) {
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() == 3) {
                if (!child.getTextContent().trim().isEmpty()) continue;
                child.setTextContent("");
                continue;
            }
            XmlFormat.trimNode(child);
        }
    }
}

