/*
 * Decompiled with CFR 0.152.
 */
package ch.turic.commands;

import ch.turic.ExecutionException;
import ch.turic.commands.AbstractCommand;
import ch.turic.commands.Command;
import ch.turic.commands.ListComposition;
import ch.turic.commands.operators.Cast;
import ch.turic.memory.AsyncStreamHandler;
import ch.turic.memory.Channel;
import ch.turic.memory.Context;
import ch.turic.memory.LngException;
import ch.turic.memory.LngList;
import ch.turic.memory.NameGen;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class AsyncEvaluation
extends AbstractCommand {
    private static final ExecutorService executor = Executors.newVirtualThreadPerTaskExecutor();
    private final Command command;
    private final Map<String, Command> options;

    public AsyncEvaluation(Command command, Map<String, Command> options) {
        this.command = command;
        this.options = options;
    }

    @Override
    public Object _execute(Context ctx) throws ExecutionException {
        int inCapacity = Integer.MAX_VALUE;
        int outCapacity = Integer.MAX_VALUE;
        int stepLimit = -1;
        long timeLimit = -1L;
        Iterator<String> iterator = this.options.keySet().iterator();
        block12: while (iterator.hasNext()) {
            Command[] commandArray;
            switch (commandArray = iterator.next()) {
                case "in": {
                    inCapacity = AsyncEvaluation.parameter((String)commandArray, ctx, this.options.get(commandArray), 1L).intValue();
                    continue block12;
                }
                case "out": {
                    outCapacity = AsyncEvaluation.parameter((String)commandArray, ctx, this.options.get(commandArray), 1L).intValue();
                    continue block12;
                }
                case "steps": {
                    stepLimit = AsyncEvaluation.parameter((String)commandArray, ctx, this.options.get(commandArray), 1L).intValue();
                    continue block12;
                }
                case "time": {
                    timeLimit = AsyncEvaluation.parameter((String)commandArray, ctx, this.options.get(commandArray), 1000L);
                    continue block12;
                }
            }
            throw new ExecutionException("Unknown option: " + (String)commandArray, new Object[0]);
        }
        ctx.globalContext.switchToMultithreading();
        Command command = this.command;
        if (command instanceof ListComposition) {
            ListComposition composition = (ListComposition)command;
            LngList lngList = new LngList();
            for (Command command2 : composition.array) {
                lngList.array.add(this.startAsyncStream(command2, ctx, outCapacity, inCapacity));
            }
            return lngList;
        }
        return this.startAsyncStream(this.command, ctx, outCapacity, inCapacity);
    }

    private AsyncStreamHandler startAsyncStream(Command command, Context ctx, int outCapacity, int inCapacity) {
        AsyncStreamHandler yielder = new AsyncStreamHandler(outCapacity, inCapacity);
        Context newThreadContext = ctx.thread();
        AsyncEvaluation.copyVariables(ctx, newThreadContext);
        newThreadContext.threadContext.addYielder(yielder);
        CompletableFuture<Channel.Message<?>> future = CompletableFuture.supplyAsync(() -> {
            Thread.currentThread().setName(NameGen.generateName());
            AsyncStreamHandler asyncStreamHandler = yielder;
            try {
                Channel.Message<Object> message = Channel.Message.of(command.execute(newThreadContext));
                if (asyncStreamHandler != null) {
                    asyncStreamHandler.close();
                }
                return message;
            }
            catch (Throwable throwable) {
                try {
                    if (asyncStreamHandler != null) {
                        try {
                            asyncStreamHandler.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception t) {
                    LngException exception = LngException.build(ctx, t, newThreadContext.threadContext.getStackTrace());
                    return Channel.Message.exception(exception);
                }
            }
        }, executor);
        yielder.setFuture(future);
        return yielder;
    }

    private static void copyVariables(Context source, Context target) {
        for (String key : source.keys()) {
            target.let0(key, source.get(key));
            target.freeze(key);
        }
    }

    private static Long parameter(String key, Context context, Command command, long multiplier) {
        Object arg = command.execute(context);
        if (Cast.isLong(arg)) {
            return Cast.toLong(arg) * multiplier;
        }
        if (Cast.isDouble(arg)) {
            return Cast.toLong(Cast.toDouble(arg) * (double)multiplier);
        }
        throw new ExecutionException("parameter %s='%s' for async is not valid", key, arg);
    }
}

