/*
 * Decompiled with CFR 0.152.
 */
package ch.turic.commands;

import ch.turic.ExecutionException;
import ch.turic.commands.AbstractCommand;
import ch.turic.commands.Command;
import ch.turic.commands.operators.Cast;
import ch.turic.memory.AsyncStreamHandler;
import ch.turic.memory.Context;
import ch.turic.memory.LngList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;

public class AwaitEvaluation
extends AbstractCommand {
    private final Command command;
    private final Map<String, Command> options;

    public AwaitEvaluation(Command command, Map<String, Command> options) {
        this.command = command;
        this.options = options;
    }

    @Override
    public Object _execute(Context ctx) throws ExecutionException {
        CompletableFuture<Object> future;
        long timeLimit = -1L;
        Iterator<String> iterator = this.options.keySet().iterator();
        while (iterator.hasNext()) {
            String key;
            switch (key = iterator.next()) {
                case "time": {
                    break;
                }
                default: {
                    throw new ExecutionException("Unknown option: " + key, new Object[0]);
                }
            }
            timeLimit = AwaitEvaluation.parameter(key, ctx, this.options.get(key), 1000L);
        }
        CompletableFuture<Object> result = this.command.execute(ctx);
        if (result instanceof LngList) {
            ArrayList futures = new ArrayList();
            for (Object f : (Iterable)((Object)result)) {
                if (f instanceof AsyncStreamHandler) {
                    AsyncStreamHandler asyncStreamHandler = (AsyncStreamHandler)f;
                    futures.add(asyncStreamHandler.future());
                    continue;
                }
                throw new ExecutionException("Cannot wait on %s ", f);
            }
            if (futures.isEmpty()) {
                return null;
            }
            future = CompletableFuture.anyOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new));
        } else {
            future = result;
        }
        if (future instanceof AsyncStreamHandler) {
            AsyncStreamHandler ash = (AsyncStreamHandler)future;
            try {
                if (timeLimit == -1L) {
                    return ash.get().get();
                }
                return ash.get(timeLimit, TimeUnit.MILLISECONDS).get();
            }
            catch (ExecutionException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ExecutionException(e);
            }
        }
        if (future instanceof CompletableFuture) {
            CompletableFuture cf = future;
            try {
                if (timeLimit == -1L) {
                    return cf.get();
                }
                return cf.get(timeLimit, TimeUnit.MILLISECONDS);
            }
            catch (Exception e) {
                throw new ExecutionException(e);
            }
        }
        throw new ExecutionException("I cannot wait for %s", future);
    }

    private static Long parameter(String key, Context context, Command command, long multiplier) {
        Object arg = command.execute(context);
        if (Cast.isLong(arg)) {
            return Cast.toLong(arg) * multiplier;
        }
        if (Cast.isDouble(arg)) {
            return Cast.toLong(Cast.toDouble(arg) * (double)multiplier);
        }
        throw new ExecutionException("parameter %s='%s' for async is not valid", key, arg);
    }
}

