/*
 * Decompiled with CFR 0.152.
 */
package ch.turic.commands;

import ch.turic.ExecutionException;
import ch.turic.commands.Command;
import ch.turic.commands.Identifier;
import ch.turic.commands.Loop;
import ch.turic.memory.Context;
import ch.turic.memory.LeftValue;
import ch.turic.memory.LngList;

public class ForEachLoop
extends Loop {
    public final Identifier identifier;
    public final Identifier with;
    public final Command expression;
    public final boolean resultList;
    public final Command body;
    public final Command exitCondition;

    public ForEachLoop(Identifier identifier, Identifier with, Command expression, boolean resultList, Command body, Command exitCondition) {
        this.identifier = identifier;
        this.with = with;
        this.expression = expression;
        this.resultList = resultList;
        this.body = body;
        this.exitCondition = exitCondition;
    }

    public Command body() {
        return this.body;
    }

    public Command expression() {
        return this.expression;
    }

    public Identifier identifier() {
        return this.identifier;
    }

    @Override
    public Object _execute(Context context) throws ExecutionException {
        context.step();
        Context loopContext = context.wrap();
        Object array = this.expression.execute(loopContext);
        Object lp = null;
        LngList listResult = this.resultList ? new LngList() : null;
        long loopCounter = 0L;
        for (Object item : LeftValue.toIterable(array)) {
            Context innerContext = loopContext.wrap();
            if (this.with != null) {
                innerContext.let0(this.with.name, loopCounter);
                innerContext.freeze(this.with.name);
            }
            innerContext.let0(this.identifier.name, item);
            innerContext.freeze(this.identifier.name);
            lp = this.loopCore(this.body, innerContext, listResult);
            if (ForEachLoop.breakLoop(lp)) {
                return ForEachLoop.normalize(lp);
            }
            lp = ForEachLoop.normalize(lp);
            if (this.exitLoop(innerContext)) break;
            ++loopCounter;
        }
        return this.resultList ? listResult : lp;
    }

    @Override
    public Command exitCondition() {
        return this.exitCondition;
    }
}

