/*
 * Decompiled with CFR 0.152.
 */
package ch.turic.commands;

import ch.turic.ExecutionException;
import ch.turic.analyzer.AssignmentList;
import ch.turic.commands.AbstractCommand;
import ch.turic.commands.Command;
import ch.turic.commands.TypeDeclaration;
import ch.turic.memory.Context;
import ch.turic.memory.HasFields;
import java.util.Iterator;

public class MultiLetAssignment
extends AbstractCommand {
    final AssignmentList.Assignment[] assignments;
    final Command rightHandSide;
    final Type type;
    final boolean mut;

    public MultiLetAssignment(AssignmentList.Assignment[] assignments, Command rightHandSide, Type type, boolean mut) {
        this.assignments = assignments;
        this.rightHandSide = rightHandSide;
        this.type = type;
        this.mut = mut;
    }

    @Override
    public Object _execute(Context ctx) throws ExecutionException {
        Object value = this.rightHandSide.execute(ctx);
        switch (this.type.ordinal()) {
            case 1: {
                this.handleObjectAssignment(ctx, value);
                break;
            }
            case 0: {
                this.handleListAssignment(ctx, value);
            }
        }
        return value;
    }

    private void handleListAssignment(Context ctx, Object value) {
        if (value instanceof Iterable) {
            Iterable iterable = (Iterable)value;
            Iterator iterator = iterable.iterator();
            for (AssignmentList.Assignment assignment : this.assignments) {
                ctx.step();
                String[] typeNames = this.getTypeNames(ctx, assignment);
                if (!iterator.hasNext()) {
                    throw new ExecutionException("[multi-let] assignment right hand side has too few values", value);
                }
                ctx.defineTypeChecked(assignment.identifier(), iterator.next(), typeNames);
                if (this.mut) continue;
                ctx.freeze(assignment.identifier());
            }
            if (iterator.hasNext()) {
                throw new ExecutionException("[multi-let] assignment right hand side has too many values", value);
            }
        } else {
            throw new ExecutionException("[multi-let] assignment got a %s value not a list", value);
        }
    }

    private void handleObjectAssignment(Context ctx, Object value) {
        if (value instanceof HasFields) {
            HasFields fields = (HasFields)value;
            for (AssignmentList.Assignment assignment : this.assignments) {
                ctx.step();
                String[] typeNames = this.getTypeNames(ctx, assignment);
                ctx.defineTypeChecked(assignment.identifier(), fields.getField(assignment.identifier()), typeNames);
            }
        } else {
            throw new ExecutionException("{multi-let} assignment got a %s value does not have fields", value);
        }
    }

    private String[] getTypeNames(Context ctx, AssignmentList.Assignment assignment) {
        String[] typeNames;
        if (assignment.types() == null) {
            typeNames = null;
        } else {
            typeNames = new String[assignment.types().length];
            for (int i = 0; i < assignment.types().length; ++i) {
                TypeDeclaration type = assignment.types()[i];
                typeNames[i] = type.calculateTypeName(ctx);
            }
        }
        return typeNames;
    }

    public static enum Type {
        LIST,
        OBJECT;

    }
}

