/*
 * Decompiled with CFR 0.152.
 */
package ch.turic.commands;

import ch.turic.BadSyntax;
import ch.turic.analyzer.Pos;
import ch.turic.commands.Command;
import ch.turic.commands.TypeDeclaration;
import java.util.Arrays;
import java.util.HashSet;

public record ParameterList(Parameter[] parameters, String rest, String meta, String closure, Pos position) {
    public static final ParameterList EMPTY = new ParameterList(new Parameter[0], null, null, null, new Pos("", null));

    public ParameterList {
        String[] others = (String[])Arrays.stream(parameters).map(Parameter::identifier).toArray(String[]::new);
        BadSyntax.when(position, ParameterList.violatesUniqueName(rest, meta, closure, others) || ParameterList.violatesUniqueName(closure, rest, meta, others) || ParameterList.violatesUniqueName(meta, closure, rest, others) || ParameterList.violatesUniqueName(others), "The parameter names have to be unique in a single declaration", new Object[0]);
    }

    private static boolean violatesUniqueName(String[] others) {
        HashSet<String> set = new HashSet<String>();
        for (String other : others) {
            if (set.contains(other)) {
                return true;
            }
            set.add(other);
        }
        return false;
    }

    private static boolean violatesUniqueName(String identifier, String other1, String other2, String[] others) {
        if (identifier == null) {
            return false;
        }
        if (identifier.equals(other1) || identifier.equals(other2)) {
            return true;
        }
        return Arrays.asList(others).contains(identifier);
    }

    public boolean fitOperator() {
        return this.parameters.length == 1 && this.parameters[0].type != Parameter.Type.NAMED_ONLY && this.rest == null && this.meta == null && this.closure == null;
    }

    public boolean fitModifier() {
        if (this.parameters.length == 0) {
            return true;
        }
        return this.parameters.length == 1 && this.parameters[0].type != Parameter.Type.NAMED_ONLY && this.rest == null && this.meta == null && this.closure == null;
    }

    public record Parameter(String identifier, Type type, TypeDeclaration[] types, Command defaultExpression) {

        public static enum Type {
            POSITIONAL_ONLY,
            NAMED_ONLY,
            POSITIONAL_OR_NAMED;

        }
    }
}

