/*
 * Decompiled with CFR 0.152.
 */
package ch.turic.commands;

import ch.turic.ExecutionException;
import ch.turic.commands.AbstractCommand;
import ch.turic.commands.Command;
import ch.turic.memory.Context;
import ch.turic.memory.LngException;

public class TryCatch
extends AbstractCommand {
    final Command tryBlock;
    final Command catchBlock;
    final Command finallyBlock;
    final String exceptionVariable;

    public TryCatch(Command tryBlock, Command catchBlock, Command finallyBlock, String exceptionVariable) {
        this.tryBlock = tryBlock;
        this.catchBlock = catchBlock;
        this.finallyBlock = finallyBlock;
        this.exceptionVariable = exceptionVariable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object _execute(Context context) throws ExecutionException {
        Object result;
        int traceSize = context.threadContext.traceSize();
        Context ctx = context.shadow();
        try {
            result = this.tryBlock.execute(ctx);
            this.exportFromTemporaryContext(ctx, context);
            if (this.exceptionVariable != null) {
                context.let0(this.exceptionVariable, null);
                context.freeze(this.exceptionVariable);
            }
        }
        catch (ExecutionException e) {
            if (this.exceptionVariable != null) {
                LngException exception = LngException.build(context, e, context.threadContext.getStackTrace());
                if (context.containsLocal(this.exceptionVariable)) {
                    throw new ExecutionException("Variable '%s' usen in catch is already defined", this.exceptionVariable);
                }
                context.local(this.exceptionVariable, exception);
                context.freeze(this.exceptionVariable);
            }
            if (this.catchBlock == null) {
                throw e;
            }
            context.threadContext.resetTrace(traceSize);
            result = this.catchBlock.execute(context);
        }
        finally {
            if (this.finallyBlock != null) {
                this.finallyBlock.execute(context);
            }
        }
        return result;
    }

    private void exportFromTemporaryContext(Context from, Context to) {
        for (String variable : from.allFrameKeys()) {
            if (to.containsFrame(variable)) {
                throw new ExecutionException("Variable '%s' is already defined.", variable);
            }
            to.local(variable, from.get(variable));
        }
    }
}

