/*
 * Decompiled with CFR 0.152.
 */
package ch.turic.commands;

import ch.turic.ExecutionException;
import ch.turic.commands.Command;
import ch.turic.commands.Loop;
import ch.turic.commands.operators.Cast;
import ch.turic.memory.Context;
import ch.turic.memory.LngList;

public class WhileLoop
extends Loop {
    public final Command startCondition;
    public final boolean resultList;
    public final Command body;
    public final Command exitCondition;

    public Command body() {
        return this.body;
    }

    @Override
    public Command exitCondition() {
        return this.exitCondition;
    }

    public WhileLoop(Command startCondition, Command exitCondition, boolean resultList, Command body) {
        this.body = body;
        this.resultList = resultList;
        this.startCondition = startCondition;
        this.exitCondition = exitCondition;
    }

    @Override
    public Object _execute(Context context) throws ExecutionException {
        Object lp = null;
        LngList listResult = this.resultList ? new LngList() : null;
        context.step();
        Context loopContext = context.wrap();
        while (Cast.toBoolean(this.startCondition.execute(loopContext))) {
            Context innerContext = loopContext.wrap();
            lp = this.loopCore(this.body, innerContext, listResult);
            if (WhileLoop.breakLoop(lp)) {
                return WhileLoop.normalize(lp);
            }
            lp = WhileLoop.normalize(lp);
            if (!this.exitLoop(innerContext)) continue;
            break;
        }
        return this.resultList ? listResult : lp;
    }
}

