/*
 * Decompiled with CFR 0.152.
 */
package ch.turic.commands.operators;

import ch.turic.ExecutionException;
import ch.turic.commands.Closure;
import ch.turic.commands.Command;
import ch.turic.commands.operators.Cast;
import ch.turic.commands.operators.Operator;
import ch.turic.memory.Context;
import ch.turic.memory.LngObject;
import java.util.function.BiPredicate;
import java.util.function.Predicate;

public abstract class Compare
implements Operator {
    public static final BiPredicate<Long, Long> LONG_LESS_THAN_PREDICATE = (a, b) -> a < b;
    public static final BiPredicate<Double, Double> DOUBLE_LESS_THAN_PREDICATE = (a, b) -> a < b;
    public static final Predicate<Integer> LESS_THAN_COMPARATOR_PREDICATE = x -> x < 0;
    public static final BiPredicate<Long, Long> LONG_LESS_EQUAL_PREDICATE = (a, b) -> a <= b;
    public static final BiPredicate<Double, Double> DOUBLE_LESS_EQUAL_PREDICATE = (a, b) -> a <= b;
    public static final Predicate<Integer> LESS_EQUAL_COMPARATOR_PREDICATE = x -> x <= 0;
    public static final BiPredicate<Long, Long> LONG_GREATER_THAN_PREDICATE = (a, b) -> a > b;
    public static final BiPredicate<Double, Double> DOUBLE_GREATER_THAN_PREDICATE = (a, b) -> a > b;
    public static final Predicate<Integer> GREATER_THAN_COMPARATOR_PREDICATE = x -> x > 0;
    public static final BiPredicate<Long, Long> LONG_GREATER_EQUAL_PREDICATE = (a, b) -> a >= b;
    public static final BiPredicate<Double, Double> DOUBLE_GREATER_EQUAL_PREDICATE = (a, b) -> a >= b;
    public static final Predicate<Integer> GREATER_EQUAL_COMPARATOR_PREDICATE = x -> x >= 0;

    public static boolean compare(Context ctx, Command left, Command right, String operator, BiPredicate<Long, Long> longComparator, BiPredicate<Double, Double> doubleComparator, Predicate<Integer> comparatorTest) throws ExecutionException {
        Object op1 = left.execute(ctx);
        Object op2 = right.execute(ctx);
        return Compare.compareEvaluated(ctx, op1, op2, operator, longComparator, doubleComparator, comparatorTest);
    }

    public static boolean compareEvaluated(Context ctx, Object op1, Object op2, String operator, BiPredicate<Long, Long> longComparator, BiPredicate<Double, Double> doubleComparator, Predicate<Integer> comparatorTest) {
        Class<?> comparableClass;
        LngObject lngOp1;
        Object method;
        if (Cast.isLong(op1) && Cast.isLong(op2)) {
            return longComparator.test(Cast.toLong(op1), Cast.toLong(op2));
        }
        if (Cast.isDouble(op1) || Cast.isDouble(op2)) {
            return doubleComparator.test(Cast.toDouble(op1), Cast.toDouble(op2));
        }
        if (op1 instanceof LngObject && (method = (lngOp1 = (LngObject)op1).getField(operator)) != null) {
            if (!(method instanceof Closure)) {
                throw new ExecutionException(String.format("%s is not a valid %s operator", method, operator), new Object[0]);
            }
            Closure operation = (Closure)method;
            Object res = operation.callAsMethod(ctx, lngOp1, operator, op2);
            if (!Cast.isBoolean(res)) {
                throw new ExecutionException(String.format("The return value of %s is '%s' cannot be used as a bool", operator, res), new Object[0]);
            }
            return Cast.toBoolean(res);
        }
        if (op1.getClass().isAssignableFrom(op2.getClass())) {
            comparableClass = op1.getClass();
        } else if (op2.getClass().isAssignableFrom(op1.getClass())) {
            comparableClass = op2.getClass();
        } else {
            throw new ExecutionException("Cannot compare types %s and %s", op1.getClass(), op2.getClass());
        }
        if (Comparable.class.isAssignableFrom(comparableClass)) {
            Comparable cop1 = (Comparable)op1;
            Comparable cop2 = (Comparable)op2;
            return comparatorTest.test(cop1.compareTo(cop2));
        }
        throw new ExecutionException("Cannot compare types of %s", comparableClass);
    }

    @Operator.Symbol(value="!=")
    public static class NotEqual
    extends Compare {
        @Override
        public Object execute(Context ctx, Command left, Command right) throws ExecutionException {
            Object op1 = left.execute(ctx);
            Object op2 = right.execute(ctx);
            if (op1 == null && op2 == null) {
                return false;
            }
            if (op1 == null || op2 == null) {
                return true;
            }
            return !op1.equals(op2);
        }
    }

    @Operator.Symbol(value="===")
    public static class Same
    extends Compare {
        @Override
        public Object execute(Context ctx, Command left, Command right) throws ExecutionException {
            Object op1 = left.execute(ctx);
            Object op2 = right.execute(ctx);
            if (Cast.isLong(op1) || Cast.isLong(op2)) {
                return op1.equals(op2);
            }
            if (Cast.isDouble(op1) || Cast.isDouble(op2)) {
                return op1.equals(op2);
            }
            return op1 == op2;
        }
    }

    @Operator.Symbol(value="==")
    public static class Equal
    extends Compare {
        @Override
        public Object execute(Context ctx, Command left, Command right) throws ExecutionException {
            Object op1 = left.execute(ctx);
            Object op2 = right.execute(ctx);
            if (op1 == null && op2 == null) {
                return true;
            }
            if (op1 == null || op2 == null) {
                return false;
            }
            return op1.equals(op2);
        }
    }

    @Operator.Symbol(value=">=")
    public static class GreaterOrEqual
    extends Compare {
        @Override
        public Object execute(Context ctx, Command left, Command right) throws ExecutionException {
            return GreaterOrEqual.compare(ctx, left, right, ">=", LONG_GREATER_EQUAL_PREDICATE, DOUBLE_GREATER_EQUAL_PREDICATE, GREATER_EQUAL_COMPARATOR_PREDICATE);
        }
    }

    @Operator.Symbol(value=">")
    public static class GreaterThan
    extends Compare {
        @Override
        public Object execute(Context ctx, Command left, Command right) throws ExecutionException {
            return GreaterThan.compare(ctx, left, right, ">", LONG_GREATER_THAN_PREDICATE, DOUBLE_GREATER_THAN_PREDICATE, GREATER_THAN_COMPARATOR_PREDICATE);
        }
    }

    @Operator.Symbol(value="<=")
    public static class LessOrEqual
    extends Compare {
        @Override
        public Object execute(Context ctx, Command left, Command right) throws ExecutionException {
            return LessOrEqual.compare(ctx, left, right, "<=", LONG_LESS_EQUAL_PREDICATE, DOUBLE_LESS_EQUAL_PREDICATE, LESS_EQUAL_COMPARATOR_PREDICATE);
        }
    }

    @Operator.Symbol(value="<")
    public static class LessThan
    extends Compare {
        @Override
        public Object execute(Context ctx, Command left, Command right) throws ExecutionException {
            return LessThan.compare(ctx, left, right, "<", LONG_LESS_THAN_PREDICATE, DOUBLE_LESS_THAN_PREDICATE, LESS_THAN_COMPARATOR_PREDICATE);
        }
    }
}

