/*
 * Decompiled with CFR 0.152.
 */
package ch.turic.commands.operators;

import ch.turic.ExecutionException;
import ch.turic.commands.Command;
import ch.turic.commands.operators.AbstractOperator;
import ch.turic.commands.operators.Cast;
import ch.turic.commands.operators.Operator;
import ch.turic.memory.Context;

@Operator.Symbol(value="<<")
public class ShiftLeft
extends AbstractOperator {
    public static double shl(double value, double shiftAmount) {
        long shift = Cast.toLong(shiftAmount);
        if (shift < 0L) {
            throw new ExecutionException("Shift amount must be non-negative", new Object[0]);
        }
        double factor = 1.0;
        double powerOfTwo = 2.0;
        while (shift != 0L) {
            if ((shift & 1L) != 0L) {
                factor *= powerOfTwo;
            }
            powerOfTwo *= powerOfTwo;
            shift >>= 1;
        }
        return value * factor;
    }

    @Override
    public Object binaryOp(Context ctx, Object op1, Command right) throws ExecutionException {
        Object op2 = right.execute(ctx);
        return this.binary("shl", op1, op2, (a, b) -> a << (int)b.longValue(), ShiftLeft::shl);
    }
}

