/*
 * Decompiled with CFR 0.152.
 */
package ch.turic.memory;

import ch.turic.ExecutionException;
import ch.turic.memory.Context;
import ch.turic.memory.HasFields;
import ch.turic.memory.HasIndex;
import ch.turic.memory.LeftValue;
import ch.turic.memory.LngObject;
import java.util.Objects;

public record ObjectFieldLeftValue(LeftValue object, String field) implements LeftValue
{
    public ObjectFieldLeftValue {
        Objects.requireNonNull(field);
    }

    @Override
    public HasFields getObject(Context ctx) {
        HasFields guaranteedObject = this.object.getObject(ctx);
        Object existing = guaranteedObject.getField(this.field);
        if (existing == null) {
            LngObject newObject = LngObject.newEmpty(ctx);
            guaranteedObject.setField(this.field, newObject);
            return newObject;
        }
        return LeftValue.toObject(existing);
    }

    @Override
    public HasIndex getIndexable(Context ctx, Object indexValue) {
        HasFields guaranteedObject = this.object.getObject(ctx);
        Object existing = guaranteedObject.getField(this.field);
        if (existing == null) {
            HasIndex newIndexable = HasIndex.createFor(indexValue, ctx);
            guaranteedObject.setField(this.field, newIndexable);
            return newIndexable;
        }
        return LeftValue.toIndexable(existing);
    }

    @Override
    public void assign(Context ctx, Object value) throws ExecutionException {
        this.object.getObject(ctx).setField(this.field, value);
    }
}

