/*
 * Decompiled with CFR 0.152.
 */
package ch.turic.memory;

import ch.turic.ExecutionException;
import ch.turic.commands.operators.Cast;
import ch.turic.memory.InfiniteValue;

public record Range(Object start, Object end) {
    @Override
    public String toString() {
        return String.valueOf(this.start) + ".." + String.valueOf(this.end);
    }

    public int getStart(int size) {
        return this.resolve(this.start, size, true);
    }

    public int getEnd(int size) {
        return this.resolve(this.end, size, false);
    }

    private int resolve(Object index, int size, boolean isStart) {
        if (index == InfiniteValue.INF_NEGATIVE) {
            return isStart ? 0 : -1;
        }
        if (index == InfiniteValue.INF_POSITIVE) {
            return size;
        }
        if (Cast.isLong(index)) {
            int limit;
            int i = Cast.toLong(index).intValue();
            if (i < 0) {
                i += size;
            }
            int n = limit = isStart ? size : size + 1;
            if (i < 0 || i > limit) {
                throw new ExecutionException("Index is out of range %d", i);
            }
            return i;
        }
        throw new ExecutionException("Cannot use '%s' as index", index);
    }
}

