/*
 * Decompiled with CFR 0.152.
 */
package ch.turic.cli;

import ch.turic.Interpreter;
import ch.turic.analyzer.Input;
import ch.turic.cli.CmdParser;
import ch.turic.commands.operators.Cast;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Set;

public class Main {
    static final Set<String> parameters = Set.of("version", "APPIA", "dry", "help");

    public static void main(String[] args) throws IOException {
        CmdParser params = CmdParser.parse(args, parameters);
        if (params.get("version").isPresent()) {
            String buildTime = new String(Main.class.getResourceAsStream("/buildtime.txt").readAllBytes(), StandardCharsets.UTF_8);
            String version = Main.class.getPackage().getImplementationVersion();
            if (version == null) {
                version = "DEV-SNAPSHOT";
            }
            System.out.printf("Turicum Version %s (Built: %s)\n", version, buildTime);
            return;
        }
        if (params.get("help").isPresent()) {
            System.out.println("Usage: turi [options] program [arguments]\n  -help                      help\n  -version                   display version\n  -APPIA=<import path>       list of directories looking for files when importing\n  -dry                       compile only\n");
            return;
        }
        if (params.get(0).isEmpty()) {
            throw new IllegalArgumentException("You must specify a program to run");
        }
        String inputFile = params.get(0).get();
        if (params.get("APPIA").isPresent()) {
            System.setProperty("APPIA", params.get("APPIA").get());
        }
        try {
            Interpreter interpreter = new Interpreter(Input.fromFile((Path)Path.of(inputFile, new String[0])));
            Object returnValue = interpreter.execute();
            if (returnValue != null && Cast.isLong((Object)returnValue)) {
                System.exit(Cast.toLong((Object)returnValue).intValue());
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            System.exit(1);
        }
    }
}

