/*
 * Decompiled with CFR 0.152.
 */
package ch.turic;

import ch.turic.BadSyntax;
import ch.turic.BuiltIns;
import ch.turic.ExecutionException;
import ch.turic.analyzer.Input;
import ch.turic.analyzer.LexList;
import ch.turic.analyzer.Lexer;
import ch.turic.analyzer.ProgramAnalyzer;
import ch.turic.commands.BlockCommand;
import ch.turic.commands.Command;
import ch.turic.memory.Context;
import ch.turic.memory.LngStackFrame;
import java.util.ArrayList;

public class Interpreter {
    private final Input source;
    private volatile Command code = null;
    private final Object lock = new Object();
    private Context preprocessorContext;
    private Context ctx;

    public Interpreter(String source) {
        this.source = Input.fromString(source);
    }

    public Interpreter(Input source) {
        this.source = source;
    }

    public ch.turic.Context getImportContext() {
        return this.ctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute() throws BadSyntax, ExecutionException {
        Command localCode = this.code;
        if (localCode == null) {
            Object object = this.lock;
            synchronized (object) {
                localCode = this.code;
                if (localCode == null) {
                    ProgramAnalyzer analyzer = new ProgramAnalyzer();
                    LexList lexes = Lexer.analyze(this.source);
                    localCode = lexes.isEmpty() ? new BlockCommand(new Command[0], false) : analyzer.analyze(lexes);
                    this.code = localCode;
                    this.preprocessorContext = analyzer.context();
                }
            }
        }
        if (this.preprocessorContext == null) {
            this.ctx = new Context();
            BuiltIns.register(this.ctx);
        } else {
            this.ctx = this.preprocessorContext.wrap();
        }
        try {
            return localCode.execute(this.ctx);
        }
        catch (ExecutionException e) {
            ArrayList<StackTraceElement> newStackTrace = new ArrayList<StackTraceElement>();
            for (LngStackFrame stackFrame : this.ctx.threadContext.getStackTrace()) {
                if (stackFrame.command().startPosition() == null) continue;
                newStackTrace.add(new StackTraceElement(stackFrame.command().getClass().getSimpleName(), "", stackFrame.command().startPosition().file, stackFrame.command().startPosition().line));
            }
            ExecutionException turiException = new ExecutionException(e);
            turiException.setStackTrace((StackTraceElement[])newStackTrace.toArray(StackTraceElement[]::new));
            throw turiException;
        }
    }
}

