/*
 * Decompiled with CFR 0.152.
 */
package ch.turic.analyzer;

import ch.turic.BadSyntax;
import ch.turic.analyzer.Lex;
import ch.turic.analyzer.Pos;
import ch.turic.memory.LngList;
import java.util.List;

public class LexList
extends LngList {
    private int index;

    public int getIndex() {
        return this.index;
    }

    public void purge() {
        this.array.subList(0, this.index).clear();
        this.index = 0;
    }

    private Lex lexAt(int index) {
        return (Lex)this.array.get(index);
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public LexList(List<Lex> lexes) {
        this.array.addAll(lexes);
    }

    public Lex next() throws BadSyntax {
        if (this.index >= this.array.size()) {
            throw new BadSyntax(this.lexAt(this.array.size() - 1).position(), "more elements expected", new Object[0]);
        }
        return this.lexAt(this.index++);
    }

    public Lex next(Lex.Type expectedType) throws BadSyntax {
        Lex lex = this.next();
        BadSyntax.when(lex.position(), lex.type() != expectedType, "%s was expected and got '%s' which is %s", expectedType.name(), lex.text(), lex.type().name());
        return lex;
    }

    public Lex next(Lex.Type type, String msg) throws BadSyntax {
        if (this.index >= this.array.size() || this.lexAt(this.index).type() != type) {
            throw new BadSyntax(this.lexAt(this.index).position(), msg, new Object[0]);
        }
        return this.next();
    }

    public Lex next(Lex.Type type, String text, String msg) throws BadSyntax {
        if (this.index >= this.array.size() || this.lexAt(this.index).type() != type || !this.lexAt(this.index).text().equals(text)) {
            throw new BadSyntax(this.lexAt(this.index).position(), msg, new Object[0]);
        }
        return this.next();
    }

    public BadSyntax syntaxError(String msg, Object ... params) {
        return new BadSyntax(this.position(), msg, params);
    }

    public Pos position() {
        if (this.index >= this.array.size()) {
            return this.lexAt(this.array.size() - 1).position();
        }
        return this.lexAt(this.index).position().clone();
    }

    public void peek(Lex.Type type, String text, String msg) throws BadSyntax {
        if (this.index >= this.array.size() || this.lexAt(this.index).type() != type || text != null && !text.equals(this.lexAt(this.index).text())) {
            throw new BadSyntax(this.lexAt(this.index).position(), msg, new Object[0]);
        }
    }

    public void next(String text, String msg) throws BadSyntax {
        this.next(Lex.Type.RESERVED, text, msg);
    }

    public Lex peek() throws BadSyntax {
        if (this.index >= this.array.size()) {
            throw new BadSyntax(this.lexAt(this.array.size() - 1).position(), "more elements expected", new Object[0]);
        }
        return this.lexAt(this.index);
    }

    public boolean hasNext() {
        return this.index < this.array.size();
    }

    public boolean hasNext(int i) {
        return this.index + i < this.array.size();
    }

    public boolean isEmpty() {
        return !this.hasNext();
    }

    public boolean isKeyword() {
        return this.hasNext() && this.lexAt(this.index).type() == Lex.Type.RESERVED && Character.isAlphabetic(this.lexAt(this.index).text().charAt(0));
    }

    public boolean isNot(String ... textAlternatives) {
        return !this.is(textAlternatives);
    }

    public boolean isAt(int i, String ... textAlternatives) {
        return this.hasNext(i) && this.lexAt(this.index + i).is(textAlternatives);
    }

    public boolean isAt(int i, Lex.Type type) {
        return this.hasNext(i) && this.lexAt(this.index + i).type() == type;
    }

    public boolean is(String ... s) {
        return this.hasNext() && this.lexAt(this.index).is(s);
    }

    public boolean isIdentifier() {
        return this.hasNext() && this.lexAt(this.index).type() == Lex.Type.IDENTIFIER;
    }

    public boolean isIdentifier(String ... textAlternatives) {
        if (!this.isIdentifier()) {
            return false;
        }
        String text = this.lexAt(this.index).text();
        for (String s : textAlternatives) {
            if (!text.equals(s)) continue;
            return true;
        }
        return false;
    }

    public boolean isConstant() {
        return this.hasNext() && (this.lexAt(this.index).type() == Lex.Type.STRING || this.lexAt(this.index).type() == Lex.Type.FLOAT || this.lexAt(this.index).type() == Lex.Type.INTEGER);
    }
}

