/*
 * Decompiled with CFR 0.152.
 */
package ch.turic.analyzer;

import ch.turic.BadSyntax;
import ch.turic.analyzer.AbstractAnalyzer;
import ch.turic.analyzer.ExpressionAnalyzer;
import ch.turic.analyzer.LexList;
import ch.turic.commands.Command;
import ch.turic.commands.Print;
import java.util.ArrayList;

public class PrintAnalyzer
extends AbstractAnalyzer {
    public static final PrintAnalyzer INSTANCE = new PrintAnalyzer(false);
    public static final PrintAnalyzer INSTANCE_NL = new PrintAnalyzer(true);
    private final boolean nl;

    public PrintAnalyzer(boolean nl) {
        this.nl = nl;
    }

    @Override
    public Command _analyze(LexList lexes) throws BadSyntax {
        ArrayList<Command> expressions;
        boolean enclosed = lexes.is("(");
        int index = lexes.getIndex();
        if (enclosed) {
            lexes.next();
            if (lexes.is(")")) {
                lexes.next();
                return new Print(new Command[0], this.nl);
            }
        }
        if ((expressions = this.getCommaSeparatedExpressions(lexes)).size() < 2 && enclosed) {
            lexes.setIndex(index);
            Command expression = ExpressionAnalyzer.INSTANCE.analyze(lexes);
            if (expression == null) {
                return new Print(new Command[0], this.nl);
            }
            return new Print(new Command[]{expression}, this.nl);
        }
        if (enclosed) {
            if (lexes.isNot(")")) {
                throw lexes.syntaxError("parameters following 'print(' should also have a closing ')' or drop the opening '(' also", new Object[0]);
            }
            lexes.next();
        }
        return new Print((Command[])expressions.toArray(Command[]::new), this.nl);
    }

    private ArrayList<Command> getCommaSeparatedExpressions(LexList lexes) {
        ArrayList<Command> expressions = new ArrayList<Command>();
        while (lexes.isNot(";")) {
            Command expression = ExpressionAnalyzer.INSTANCE.analyze(lexes);
            if (expression != null) {
                expressions.add(expression);
            }
            if (lexes.isNot(",")) break;
            lexes.next();
        }
        return expressions;
    }
}

