/*
 * Decompiled with CFR 0.152.
 */
package ch.turic.builtins.classes;

import ch.turic.ExecutionException;
import ch.turic.LngCallable;
import ch.turic.TuriClass;
import ch.turic.analyzer.Input;
import ch.turic.analyzer.LexList;
import ch.turic.analyzer.Lexer;
import ch.turic.analyzer.ProgramAnalyzer;
import ch.turic.builtins.classes.TuriMethod;
import ch.turic.builtins.functions.FunUtils;
import ch.turic.commands.Command;
import ch.turic.commands.operators.Cast;
import ch.turic.memory.Context;
import ch.turic.memory.LngList;
import ch.turic.memory.LngStackFrame;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.stream.Collectors;

public class TuriString
implements TuriClass {
    @Override
    public Class<?> forClass() {
        return String.class;
    }

    @Override
    public LngCallable getMethod(Object target, String identifier) {
        if (!(target instanceof String)) {
            throw new ExecutionException("Target object is not a String, this is an internal error", new Object[0]);
        }
        String string = (String)target;
        return switch (identifier) {
            case "to_string" -> new TuriMethod<String>(args -> String.format("%s", string));
            case "after" -> new TuriMethod<String>(args -> {
                String afterWhat = String.valueOf(args[0]);
                int pos = string.indexOf(afterWhat);
                if (pos < 0) {
                    return "";
                }
                return string.substring(pos + afterWhat.length());
            });
            case "before" -> new TuriMethod<String>(args -> {
                String beforeWhat = String.valueOf(args[0]);
                int pos = string.indexOf(beforeWhat);
                if (pos < 0) {
                    return "";
                }
                return string.substring(0, pos);
            });
            case "pad_left" -> new TuriMethod<String>(args -> {
                String pad = ((Object[])args).length == 2 ? String.valueOf(args[0]) : " ";
                ExecutionException.when(pad.isEmpty(), "cannot pad with empty string", new Object[0]);
                int n = Cast.toLong(((Object[])args).length == 2 ? args[1] : args[0]).intValue();
                if (n <= string.length()) {
                    return string;
                }
                int k = (n - string.length()) / pad.length();
                return pad.repeat(k) + string;
            });
            case "pad_right" -> new TuriMethod<String>(args -> {
                String pad = ((Object[])args).length == 2 ? String.valueOf(args[0]) : " ";
                ExecutionException.when(pad.isEmpty(), "cannot pad with empty string", new Object[0]);
                int n = Cast.toLong(((Object[])args).length == 2 ? args[1] : args[0]).intValue();
                if (n <= string.length()) {
                    return string;
                }
                int k = (n - string.length()) / pad.length();
                return string + pad.repeat(k);
            });
            case "between" -> new TuriMethod<String>(args -> {
                String afterWhat = String.valueOf(args[0]);
                String beforeWhat = String.valueOf(args[1]);
                int pos1 = string.indexOf(beforeWhat);
                int pos2 = string.indexOf(afterWhat);
                if (pos1 < 0 || pos2 < 0) {
                    return "";
                }
                return string.substring(pos2 + afterWhat.length(), pos1);
            });
            case "lines" -> new TuriMethod<LngList>(args -> {
                LngList list = new LngList();
                list.array.addAll(Arrays.asList(string.split("\n", -1)));
                return list;
            });
            case "words" -> new TuriMethod<LngList>(args -> {
                LngList list = new LngList();
                list.array.addAll(Arrays.asList(string.split("\\W+", -1)));
                return list;
            });
            case "turi_lex" -> new TuriMethod<LexList>(args -> Lexer.analyze(Input.fromString(string)));
            case "execute" -> (context, args) -> {
                Context ctx = FunUtils.ctx(context);
                ProgramAnalyzer analyzer = new ProgramAnalyzer();
                Command code = analyzer.analyze(Lexer.analyze(Input.fromString(string)));
                Object result = null;
                try {
                    result = code.execute(ctx);
                }
                catch (ExecutionException e) {
                    ArrayList<StackTraceElement> newStackTrace = new ArrayList<StackTraceElement>();
                    for (LngStackFrame stackFrame : ctx.threadContext.getStackTrace()) {
                        if (stackFrame.command().startPosition() == null) continue;
                        newStackTrace.add(new StackTraceElement(stackFrame.command().getClass().getSimpleName(), "", stackFrame.command().startPosition().file, stackFrame.command().startPosition().line));
                    }
                    ExecutionException turiException = new ExecutionException(e);
                    turiException.setStackTrace((StackTraceElement[])newStackTrace.toArray(StackTraceElement[]::new));
                    result = turiException;
                }
                return result;
            };
            case "url_encode" -> new TuriMethod<String>(args -> URLEncoder.encode(string, StandardCharsets.UTF_8));
            case "url_decode" -> new TuriMethod<String>(args -> URLDecoder.decode(string, StandardCharsets.UTF_8));
            case "md5" -> new TuriMethod<String>(args -> TuriString.digest(string, "MD5"));
            case "sha_1" -> new TuriMethod<String>(args -> TuriString.digest(string, "SHA-1"));
            case "sha_256" -> new TuriMethod<String>(args -> TuriString.digest(string, "SHA-256"));
            case "sha_512" -> new TuriMethod<String>(args -> TuriString.digest(string, "SHA-512"));
            case "digest" -> new TuriMethod<String>(args -> TuriString.digest(string, String.valueOf(args[0])));
            case "base64" -> new TuriMethod<String>(args -> {
                Base64.Encoder encoder = Base64.getEncoder();
                return encoder.encodeToString(string.getBytes(StandardCharsets.UTF_8));
            });
            case "from_base64" -> new TuriMethod<LngList>(args -> {
                Base64.Decoder decoder = Base64.getDecoder();
                byte[] bytes = decoder.decode(string);
                LngList list = new LngList();
                for (byte aByte : bytes) {
                    list.array.add(aByte);
                }
                return list;
            });
            case "from_base64_str" -> new TuriMethod<String>(args -> {
                Base64.Decoder decoder = Base64.getDecoder();
                return new String(decoder.decode(string), StandardCharsets.UTF_8);
            });
            case "contains" -> new TuriMethod<Boolean>(args -> string.contains(String.valueOf(args[0])));
            case "is_blank" -> new TuriMethod<Boolean>(args -> string.isBlank());
            case "is_empty" -> new TuriMethod<Boolean>(args -> string.isEmpty());
            case "is_numeric" -> new TuriMethod<Boolean>(args -> string.matches("^[-+]?\\d+(\\.\\d+)?([eE][-+]?\\d+)?$"));
            case "is_digit" -> new TuriMethod<Boolean>(args -> string.matches("^\\d+$"));
            case "is_alpha" -> new TuriMethod<Boolean>(args -> string.matches("^[a-zA-Z]+$"));
            case "is_alphanumeric" -> new TuriMethod<Boolean>(args -> string.matches("^[a-zA-Z0-9]+$"));
            case "is_hex" -> new TuriMethod<Boolean>(args -> string.matches("^(0x)?[a-fA-F0-9]+$"));
            case "hex" -> new TuriMethod<Long>(args -> {
                String hexString = string.trim();
                if (hexString.startsWith("0x") || hexString.startsWith("0X")) {
                    return Long.parseLong(hexString.substring(2), 16);
                }
                return Long.parseLong(hexString, 16);
            });
            case "substring" -> new TuriMethod<String>(args -> {
                if (((Object[])args).length == 1) {
                    return string.substring(Cast.toLong(args[0]).intValue());
                }
                if (((Object[])args).length == 2) {
                    return string.substring(Cast.toLong(args[0]).intValue(), Cast.toLong(args[1]).intValue());
                }
                throw new ExecutionException("substring() needs one or two arguments", new Object[0]);
            });
            case "remove_prefix" -> new TuriMethod<String>(args -> {
                String prefix = String.valueOf(args[0]);
                if (string.startsWith(prefix)) {
                    return string.substring(prefix.length());
                }
                return string;
            });
            case "remove_postfix" -> new TuriMethod<String>(args -> {
                String postfix = String.valueOf(args[0]);
                if (string.endsWith(postfix)) {
                    return string.substring(0, string.length() - postfix.length());
                }
                return string;
            });
            case "count_substring" -> new TuriMethod<Long>(args -> {
                String substr = String.valueOf(args[0]);
                int i = 0;
                long count = 0L;
                while ((i = string.indexOf(substr, i)) >= 0) {
                    i += substr.length();
                    ++count;
                }
                return count;
            });
            case "left" -> new TuriMethod<String>(args -> string.substring(0, Cast.toLong(args[0]).intValue()));
            case "right" -> new TuriMethod<String>(args -> string.substring(string.length() - Cast.toLong(args[0]).intValue()));
            case "replace_all" -> new TuriMethod<String>(args -> string.replaceAll(String.valueOf(args[0]), String.valueOf(args[1])));
            case "quote" -> new TuriMethod<String>(args -> string.replace("\\", "\\\\").replace("\t", "\\t").replace("\b", "\\b").replace("\n", "\\n").replace("\r", "\\r").replace("\f", "\\f").replace("\"", "\\\""));
            case "reverse" -> new TuriMethod<String>(args -> new StringBuilder(string).reverse().toString());
            case "chop" -> new TuriMethod<String>(args -> string.substring(0, string.length() - 1));
            case "chomp" -> new TuriMethod<String>(args -> string.endsWith("\n") ? string.substring(0, string.length() - 1) : string);
            case "times" -> new TuriMethod<String>(args -> string.repeat(Cast.toLong(args[0]).intValue()));
            case "lower_case" -> new TuriMethod<String>(args -> string.toLowerCase());
            case "upper_case" -> new TuriMethod<String>(args -> string.toUpperCase());
            case "trim" -> new TuriMethod<String>(args -> string.trim());
            case "starts_with" -> new TuriMethod<Boolean>(args -> string.startsWith(args[0].toString()));
            case "ends_with" -> new TuriMethod<Boolean>(args -> string.endsWith(args[0].toString()));
            case "split" -> new TuriMethod<LngList>(args -> {
                LngList list = new LngList();
                list.array.addAll(Arrays.asList(string.split(args[0].toString(), -1)));
                return list;
            });
            case "bytes" -> new TuriMethod<LngList>(args -> {
                byte[] bytes;
                LngList list = new LngList();
                for (byte b : bytes = string.getBytes(StandardCharsets.UTF_8)) {
                    list.array.add(b);
                }
                return list;
            });
            case "join" -> new TuriMethod<String>(args -> {
                if (((Object[])args).length != 1) {
                    throw new ExecutionException("join() needs one argument, a list", new Object[0]);
                }
                Object patt0$temp = args[0];
                if (patt0$temp instanceof LngList) {
                    LngList list = (LngList)patt0$temp;
                    return list.array.stream().map(Object::toString).collect(Collectors.joining(string));
                }
                throw new ExecutionException("join() needs one argument, a list. '%s' is not a list", args[0]);
            });
            case "char_at" -> new TuriMethod<String>(args -> "" + string.charAt(Cast.toLong(args[0]).intValue()));
            case "safe_char_at" -> new TuriMethod<String>(args -> {
                int index = Cast.toLong(args[0]).intValue();
                if (index < 0 || index >= string.length()) {
                    return "";
                }
                return "" + string.charAt(index);
            });
            case "index_of" -> new TuriMethod<Long>(args -> string.indexOf(args[0].toString()));
            case "last_index_of" -> new TuriMethod<Long>(args -> string.lastIndexOf(args[0].toString()));
            default -> null;
        };
    }

    public static String digest(String input, String type) {
        try {
            MessageDigest md = MessageDigest.getInstance(type);
            byte[] digest = md.digest(input.getBytes(StandardCharsets.UTF_8));
            StringBuilder hexString = new StringBuilder();
            for (byte b : digest) {
                String hex = Integer.toHexString(0xFF & b);
                if (hex.length() == 1) {
                    hexString.append('0');
                }
                hexString.append(hex);
            }
            return hexString.toString();
        }
        catch (NoSuchAlgorithmException e) {
            throw new ExecutionException(e);
        }
    }
}

