/*
 * Decompiled with CFR 0.152.
 */
package ch.turic.builtins.functions;

import ch.turic.Context;
import ch.turic.ExecutionException;
import ch.turic.TuriFunction;
import ch.turic.builtins.functions.FunUtils;
import ch.turic.builtins.functions.JavaMethodCall;
import ch.turic.memory.LngList;
import java.lang.invoke.TypeDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class JavaMethodCallVararg
implements TuriFunction {
    @Override
    public String name() {
        return "java_call_vararg";
    }

    @Override
    public Object call(Context ctx, Object[] arguments) throws ExecutionException {
        FunUtils.twoArgs(this.name(), arguments);
        Object object = arguments[arguments.length - 1];
        if (!(object instanceof LngList)) {
            throw new ExecutionException("The last argument of '%s' must be a list type.", this.name());
        }
        LngList varargList = (LngList)object;
        Object object2 = arguments[1];
        if (!(object2 instanceof String)) {
            throw new ExecutionException("Function %s needs a method name as a second argument.", this.name());
        }
        String methodName = (String)object2;
        JavaMethodCall.KlassAndObject klob = JavaMethodCall.getKlassAndObject(arguments);
        Class<?> klass = klob.klass();
        Object object3 = klob.object();
        for (Method method : klass.getMethods()) {
            Class<?> pType;
            if (!method.getName().equals(methodName) || method.isSynthetic() || !method.isVarArgs() || method.getParameterCount() != arguments.length - 2) continue;
            int i = 2;
            int j = 0;
            while (j < method.getParameterTypes().length - 1 && (pType = method.getParameterTypes()[j]).isAssignableFrom(arguments[i].getClass())) {
                TypeDescriptor.OfField lastPType = method.getParameterTypes()[method.getParameterTypes().length - 1].arrayType();
                while (i < arguments.length - 1 && ((Class)lastPType).isAssignableFrom(arguments[i].getClass())) {
                    ++i;
                }
                ++j;
                ++i;
            }
            if (i != arguments.length - 1) continue;
            try {
                Object[] args = new Object[method.getParameterCount()];
                int k = 2;
                int h = 0;
                while (h < method.getParameterCount() - 1) {
                    args[h++] = arguments[k++];
                }
                Class<?> varargComponentType = method.getParameterTypes()[method.getParameterCount() - 1].getComponentType();
                Object varargs = Array.newInstance(varargComponentType, varargList.array.size());
                for (int v = 0; v < varargList.array.size(); ++v) {
                    Object vararg = varargList.array.get(v);
                    Array.set(varargs, v, vararg);
                }
                args[h] = varargs;
                return method.invoke(object3, args);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new ExecutionException("Cannot invoke method '" + methodName + "'.", new Object[]{e});
            }
        }
        throw new ExecutionException("Cannot find method '" + methodName + "'.", new Object[0]);
    }
}

