/*
 * Decompiled with CFR 0.152.
 */
package ch.turic.builtins.functions;

import ch.turic.Context;
import ch.turic.ExecutionException;
import ch.turic.TuriFunction;
import ch.turic.builtins.functions.FunUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;

public class JavaNewObject
implements TuriFunction {
    @Override
    public String name() {
        return "java_object";
    }

    @Override
    public Object call(Context ctx, Object[] arguments) throws ExecutionException {
        FunUtils.needArg(this.name(), arguments);
        Object object = arguments[0];
        if (object instanceof String) {
            String className = (String)object;
            try {
                Class<?> klass = Class.forName(className);
                for (Constructor<?> constructor : klass.getConstructors()) {
                    if (constructor.getParameterCount() != arguments.length - 1 || constructor.isSynthetic()) continue;
                    int i = 1;
                    for (Class<?> pType : constructor.getParameterTypes()) {
                        if (!pType.isAssignableFrom(arguments[i].getClass())) break;
                        ++i;
                    }
                    if (i != arguments.length) continue;
                    Object[] args = Arrays.copyOfRange(arguments, 1, arguments.length);
                    return constructor.newInstance(args);
                }
                throw new ExecutionException("No suitable constructor found for class " + className, new Object[0]);
            }
            catch (ClassNotFoundException e) {
                throw new ExecutionException("Could not load class " + className, new Object[]{e});
            }
            catch (InvocationTargetException e) {
                throw new ExecutionException("Could not invoke constructor " + className, new Object[]{e.getCause()});
            }
            catch (InstantiationException e) {
                throw new ExecutionException("Could not instantiate class " + className, new Object[]{e});
            }
            catch (IllegalAccessException e) {
                throw new ExecutionException("Could not access constructor " + className, new Object[]{e});
            }
        }
        throw new ExecutionException("Function %s requires a class name.", this.name());
    }
}

