/*
 * Decompiled with CFR 0.152.
 */
package ch.turic.builtins.functions;

import ch.turic.Context;
import ch.turic.ExecutionException;
import ch.turic.TuriFunction;
import ch.turic.builtins.functions.FunUtils;
import ch.turic.commands.operators.Cast;
import java.util.function.BiFunction;
import java.util.function.Function;

public class MathFunctions {

    public static class NextUp
    extends MathFunc1 {
        public NextUp() {
            super(Math::nextUp);
        }

        @Override
        public String name() {
            return "next_up";
        }
    }

    public static class NextAfter
    extends MathFunc2 {
        public NextAfter() {
            super(Math::nextAfter);
        }

        @Override
        public String name() {
            return "next_after";
        }
    }

    public static class Hypot
    extends MathFunc2 {
        public Hypot() {
            super(Math::hypot);
        }

        @Override
        public String name() {
            return "hypot";
        }
    }

    public static class CopySign
    extends MathFunc2 {
        public CopySign() {
            super(Math::copySign);
        }

        @Override
        public String name() {
            return "copy_sign";
        }
    }

    public static class IEEEremainder
    extends MathFunc2 {
        public IEEEremainder() {
            super(Math::IEEEremainder);
        }

        @Override
        public String name() {
            return "ieee_remainder";
        }
    }

    public static class Atan2
    extends MathFunc2 {
        public Atan2() {
            super(Math::atan2);
        }

        @Override
        public String name() {
            return "atan2";
        }
    }

    public static class Pow
    extends MathFunc2 {
        public Pow() {
            super(Math::pow);
        }

        @Override
        public String name() {
            return "pow";
        }
    }

    public static class ToRadians
    extends MathFunc1 {
        public ToRadians() {
            super(Math::toRadians);
        }

        @Override
        public String name() {
            return "to_radians";
        }
    }

    public static class ToDegrees
    extends MathFunc1 {
        public ToDegrees() {
            super(Math::toDegrees);
        }

        @Override
        public String name() {
            return "to_degrees";
        }
    }

    public static class Rint
    extends MathFunc1 {
        public Rint() {
            super(Math::rint);
        }

        @Override
        public String name() {
            return "rint";
        }
    }

    public static class Ulp
    extends MathFunc1 {
        public Ulp() {
            super(Math::ulp);
        }

        @Override
        public String name() {
            return "ulp";
        }
    }

    public static class NextDown
    extends MathFunc1 {
        public NextDown() {
            super(Math::nextDown);
        }

        @Override
        public String name() {
            return "next_down";
        }
    }

    public static class SigNum
    extends MathFunc1 {
        public SigNum() {
            super(Math::signum);
        }

        @Override
        public String name() {
            return "signum";
        }
    }

    public static class Round
    extends MathFunc1l {
        public Round() {
            super(Math::round);
        }

        @Override
        public String name() {
            return "round";
        }
    }

    public static class GetExponent
    extends MathFunc1i {
        public GetExponent() {
            super(Math::getExponent);
        }

        @Override
        public String name() {
            return "get_exponent";
        }
    }

    public static class Cosh
    extends MathFunc1 {
        public Cosh() {
            super(Math::cosh);
        }

        @Override
        public String name() {
            return "cosh";
        }
    }

    public static class Sinh
    extends MathFunc1 {
        public Sinh() {
            super(Math::sinh);
        }

        @Override
        public String name() {
            return "sinh";
        }
    }

    public static class Tanh
    extends MathFunc1 {
        public Tanh() {
            super(Math::tanh);
        }

        @Override
        public String name() {
            return "tanh";
        }
    }

    public static class Tan
    extends MathFunc1 {
        public Tan() {
            super(Math::tan);
        }

        @Override
        public String name() {
            return "tan";
        }
    }

    public static class Sqrt
    extends MathFunc1 {
        public Sqrt() {
            super(Math::sqrt);
        }

        @Override
        public String name() {
            return "sqrt";
        }
    }

    public static class Log10
    extends MathFunc1 {
        public Log10() {
            super(Math::log10);
        }

        @Override
        public String name() {
            return "log10";
        }
    }

    public static class Log
    extends MathFunc1 {
        public Log() {
            super(Math::log);
        }

        @Override
        public String name() {
            return "log";
        }
    }

    public static class Floor
    extends MathFunc1 {
        public Floor() {
            super(Math::floor);
        }

        @Override
        public String name() {
            return "floor";
        }
    }

    public static class Exp
    extends MathFunc1 {
        public Exp() {
            super(Math::exp);
        }

        @Override
        public String name() {
            return "exp";
        }
    }

    public static class Abs
    extends MathFunc1 {
        public Abs() {
            super(Math::abs);
        }

        @Override
        public String name() {
            return "abs";
        }
    }

    public static class Ceil
    extends MathFunc1 {
        public Ceil() {
            super(Math::ceil);
        }

        @Override
        public String name() {
            return "ceil";
        }
    }

    public static class Cbrt
    extends MathFunc1 {
        public Cbrt() {
            super(Math::cbrt);
        }

        @Override
        public String name() {
            return "cbrt";
        }
    }

    public static class Atan
    extends MathFunc1 {
        public Atan() {
            super(Math::atan);
        }

        @Override
        public String name() {
            return "atan";
        }
    }

    public static class Asin
    extends MathFunc1 {
        public Asin() {
            super(Math::asin);
        }

        @Override
        public String name() {
            return "asin";
        }
    }

    public static class ACos
    extends MathFunc1 {
        public ACos() {
            super(Math::acos);
        }

        @Override
        public String name() {
            return "acos";
        }
    }

    public static class Cos
    extends MathFunc1 {
        public Cos() {
            super(Math::cos);
        }

        @Override
        public String name() {
            return "cos";
        }
    }

    public static class Sin
    extends MathFunc1 {
        public Sin() {
            super(Math::sin);
        }

        @Override
        public String name() {
            return "sin";
        }
    }

    public static class Scalb
    implements TuriFunction {
        @Override
        public String name() {
            return "scalb";
        }

        @Override
        public Object call(Context context, Object[] args) throws ExecutionException {
            double _a;
            FunUtils.twoArgs(this.name(), args);
            Object a = args[0];
            Object b = args[1];
            if (Cast.isLong(a)) {
                _a = Cast.toLong(a).longValue();
            } else if (Cast.isDouble(a)) {
                _a = Cast.toDouble(a);
            } else {
                throw new ExecutionException("%s first argument is not a long/double", this.name());
            }
            if (!Cast.isLong(b)) {
                throw new ExecutionException("%s second argument is not an integer number", this.name());
            }
            int _b = Cast.toLong(b).intValue();
            return Math.scalb(_a, _b);
        }
    }

    private static abstract class MathFunc2
    implements TuriFunction {
        private final BiFunction<Double, Double, Double> functions;

        private MathFunc2(BiFunction<Double, Double, Double> functions) {
            this.functions = functions;
        }

        @Override
        public Object call(Context context, Object[] args) throws ExecutionException {
            double _b;
            double _a;
            FunUtils.twoArgs(this.name(), args);
            Object a = args[0];
            Object b = args[1];
            if (Cast.isLong(a)) {
                _a = Cast.toLong(a).longValue();
            } else if (Cast.isDouble(a)) {
                _a = Cast.toDouble(a);
            } else {
                throw new ExecutionException("%s first argument is not a long/double", this.name());
            }
            if (Cast.isLong(b)) {
                _b = Cast.toLong(b).longValue();
            } else if (Cast.isDouble(b)) {
                _b = Cast.toDouble(b);
            } else {
                throw new ExecutionException("%s second argument is not a long/double", this.name());
            }
            return this.functions.apply(_a, _b);
        }
    }

    private static abstract class MathFunc1l
    implements TuriFunction {
        private final Function<Double, Long> functions;

        private MathFunc1l(Function<Double, Long> functions) {
            this.functions = functions;
        }

        @Override
        public Long call(Context context, Object[] args) throws ExecutionException {
            FunUtils.oneArg(this.name(), args);
            Object arg = args[0];
            if (Cast.isLong(arg)) {
                return this.functions.apply((double)Cast.toLong(arg));
            }
            if (Cast.isDouble(arg)) {
                return this.functions.apply(Cast.toDouble(arg));
            }
            throw new ExecutionException("%s argument is not a long/double", this.name());
        }
    }

    private static abstract class MathFunc1i
    implements TuriFunction {
        private final Function<Double, Integer> functions;

        private MathFunc1i(Function<Double, Integer> functions) {
            this.functions = functions;
        }

        @Override
        public Integer call(Context context, Object[] args) throws ExecutionException {
            FunUtils.oneArg(this.name(), args);
            Object arg = args[0];
            if (Cast.isLong(arg)) {
                return this.functions.apply((double)Cast.toLong(arg));
            }
            if (Cast.isDouble(arg)) {
                return this.functions.apply(Cast.toDouble(arg));
            }
            throw new ExecutionException("%s argument is not a long/double", this.name());
        }
    }

    private static abstract class MathFunc1
    implements TuriFunction {
        private final Function<Double, Double> functions;

        private MathFunc1(Function<Double, Double> functions) {
            this.functions = functions;
        }

        @Override
        public Object call(Context context, Object[] args) throws ExecutionException {
            FunUtils.oneArg(this.name(), args);
            Object arg = args[0];
            if (Cast.isLong(arg)) {
                return this.functions.apply((double)Cast.toLong(arg));
            }
            if (Cast.isDouble(arg)) {
                return this.functions.apply(Cast.toDouble(arg));
            }
            throw new ExecutionException("%s argument is not a long/double", this.name());
        }
    }

    public static class Random
    implements TuriFunction {
        @Override
        public String name() {
            return "random";
        }

        @Override
        public Object call(Context context, Object[] args) throws ExecutionException {
            FunUtils.noArg(this.name(), args);
            return Math.random();
        }
    }
}

