/*
 * Decompiled with CFR 0.152.
 */
package ch.turic.commands;

import ch.turic.ExecutionException;
import ch.turic.commands.AbstractCommand;
import ch.turic.commands.BlockCommand;
import ch.turic.commands.BreakCommand;
import ch.turic.commands.ClosureOrMacro;
import ch.turic.commands.Command;
import ch.turic.commands.Conditional;
import ch.turic.commands.FunctionCall;
import ch.turic.commands.ParameterList;
import ch.turic.memory.Context;
import ch.turic.memory.HasFields;
import ch.turic.utils.NullableOptional;

public final class Macro
extends AbstractCommand
implements ClosureOrMacro {
    final ParameterList parameters;
    final Context wrapped;
    final BlockCommand command;
    final String name;

    @Override
    public String name() {
        return this.name;
    }

    public BlockCommand command() {
        return this.command;
    }

    @Override
    public ParameterList parameters() {
        return this.parameters;
    }

    @Override
    public Context wrapped() {
        return this.wrapped;
    }

    public Macro(String name, ParameterList parameters, Context wrapped, BlockCommand command) {
        this.parameters = parameters;
        this.wrapped = wrapped;
        this.command = command;
        this.name = name;
    }

    @Override
    public Object _execute(Context ctx) throws ExecutionException {
        ctx.step();
        Object result = null;
        for (Command command : this.command.commands()) {
            Conditional.ReturnResult returnResult;
            ExecutionException.when(command instanceof BreakCommand, "You cannot break from a function or closure. Use Return", new Object[0]);
            result = command.execute(ctx);
            if (!(result instanceof Conditional.ReturnResult) || !(returnResult = (Conditional.ReturnResult)result).isDone()) continue;
            return returnResult.result();
        }
        return result;
    }

    @Override
    public NullableOptional<Object> methodCall(Context context, HasFields obj, String methodName, FunctionCall.Argument[] arguments) {
        FunctionCall.ArgumentEvaluated[] argValues = this.evaluateArguments(context, arguments);
        return ClosureOrMacro.callTheMethod(context, obj, methodName, argValues, this);
    }

    @Override
    public FunctionCall.ArgumentEvaluated[] evaluateArguments(Context context, FunctionCall.Argument[] arguments) {
        return Macro.evaluateMacroArguments(context, arguments);
    }

    public static FunctionCall.ArgumentEvaluated[] evaluateMacroArguments(Context context, FunctionCall.Argument[] arguments) {
        FunctionCall.ArgumentEvaluated[] argValues = arguments == null ? new FunctionCall.ArgumentEvaluated[]{} : new FunctionCall.ArgumentEvaluated[arguments.length];
        for (int i = 0; i < argValues.length; ++i) {
            argValues[i] = new FunctionCall.ArgumentEvaluated(arguments[i].id(), arguments[i].expression());
        }
        return argValues;
    }
}

