/*
 * Decompiled with CFR 0.152.
 */
package ch.turic.commands;

import ch.turic.ExecutionException;
import ch.turic.commands.AbstractCommand;
import ch.turic.commands.Command;
import ch.turic.commands.operators.Operator;
import ch.turic.memory.Context;
import java.util.Objects;

public class Operation
extends AbstractCommand {
    final String operator;
    final Command left;
    final Command right;

    public Command left() {
        return this.left;
    }

    public String operator() {
        return this.operator;
    }

    public Command right() {
        return this.right;
    }

    public Operation(String operator, Command left, Command right) {
        Objects.requireNonNull(operator);
        Objects.requireNonNull(right);
        this.operator = operator;
        this.left = left;
        this.right = right;
    }

    @Override
    public Object _execute(Context ctx) throws ExecutionException {
        ctx.step();
        if (Operator.OPERATORS.containsKey(this.operator)) {
            Operator op = Operator.OPERATORS.get(this.operator);
            return op.execute(ctx, this.left, this.right);
        }
        throw new ExecutionException("Unknown operator " + this.operator, new Object[0]);
    }
}

