/*
 * Decompiled with CFR 0.152.
 */
package ch.turic.commands;

import ch.turic.ExecutionException;
import ch.turic.analyzer.WithAnalyzer;
import ch.turic.commands.AbstractCommand;
import ch.turic.commands.Closure;
import ch.turic.commands.Command;
import ch.turic.commands.operators.Cast;
import ch.turic.memory.Context;
import ch.turic.memory.LngException;
import ch.turic.memory.LngObject;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;

public class WithCommand
extends AbstractCommand {
    private static final Object[] NO_PARAMS = new Object[0];
    public static final String METHOD_NAME_ENTRY = "entry";
    public static final String METHOD_NAME_EXIT = "exit";
    public final WithAnalyzer.WithPair[] pairs;
    public final Command body;

    public Command body() {
        return this.body;
    }

    public WithCommand(WithAnalyzer.WithPair[] pairs, Command body) {
        this.body = body;
        this.pairs = pairs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object _execute(Context context) throws ExecutionException {
        context.step();
        Context ctx = context;
        AtomicBoolean supressExceptions = new AtomicBoolean(false);
        ArrayList<RuntimeException> closeExceptions = new ArrayList<RuntimeException>();
        ExecutionException exception = null;
        ArrayList<LngObject> objects = new ArrayList<LngObject>();
        try {
            for (WithAnalyzer.WithPair pair : this.pairs) {
                Object obj = pair.command().execute(context);
                ctx = WithCommand.wrapCallingEntry(context, pair, obj, objects, ctx);
            }
            Object object = this.body.execute(ctx);
            return object;
        }
        catch (ExecutionException executionException) {
            exception = executionException;
        }
        finally {
            WithCommand.callExitMethods(context, exception, objects, supressExceptions, closeExceptions);
            WithCommand.throwClosingOnlyExceptionsIfAny(exception, closeExceptions);
        }
        return WithCommand.nullOrThrowTheExceptions(closeExceptions, exception, supressExceptions.get());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Context wrapCallingEntry(Context context, WithAnalyzer.WithPair pair, Object obj, ArrayList<LngObject> objects, Context ctx) {
        LngObject resourceHandle;
        if (!(obj instanceof LngObject)) throw new ExecutionException("expression '%s' in 'with' resulted a non-object '%s'", pair, obj);
        LngObject lngObject = (LngObject)obj;
        if (pair.alias() == null) {
            return ctx.with(lngObject.context());
        }
        objects.add(lngObject);
        Object entry = lngObject.getField(METHOD_NAME_ENTRY);
        if (!(entry instanceof Closure)) throw new ExecutionException("Resource in a 'with' statement without proper '%s' method", METHOD_NAME_ENTRY);
        Closure closure = (Closure)entry;
        Object entryResult = closure.callAsMethod(context, lngObject, METHOD_NAME_ENTRY, NO_PARAMS);
        if (entryResult == null) {
            resourceHandle = lngObject;
        } else {
            LngObject lngObjectResult;
            if (!(entryResult instanceof LngObject)) throw new ExecutionException("entry for object '%s' returned a non object '%s'", closure, entryResult);
            resourceHandle = lngObjectResult = (LngObject)entryResult;
        }
        ctx = ctx.wrap();
        ctx.let0(pair.alias(), resourceHandle);
        return ctx;
    }

    private static Object nullOrThrowTheExceptions(ArrayList<RuntimeException> closeExceptions, ExecutionException exception, boolean supressExceptions) {
        if (!closeExceptions.isEmpty()) {
            for (RuntimeException ce : closeExceptions) {
                exception.addSuppressed(ce);
            }
        }
        if (supressExceptions) {
            return null;
        }
        throw exception;
    }

    private static void throwClosingOnlyExceptionsIfAny(ExecutionException exception, ArrayList<RuntimeException> closeExceptions) {
        if (exception == null && !closeExceptions.isEmpty()) {
            if (closeExceptions.size() == 1) {
                throw closeExceptions.getFirst();
            }
            ExecutionException e = new ExecutionException("Exceptions closing resources", new Object[0]);
            for (RuntimeException ce : closeExceptions) {
                e.addSuppressed(ce);
            }
            throw e;
        }
    }

    private static void callExitMethods(Context context, ExecutionException exception, ArrayList<LngObject> lngObjects, AtomicBoolean supressExceptions, ArrayList<RuntimeException> closeExceptions) {
        LngException param = exception != null ? LngException.build(context, exception, context.threadContext.getStackTrace()) : null;
        for (LngObject lngObject : lngObjects.reversed()) {
            try {
                Object entry = lngObject.getField(METHOD_NAME_EXIT);
                if (!(entry instanceof Closure)) continue;
                Closure closure = (Closure)entry;
                boolean exitValue = Cast.toBoolean(closure.callAsMethod(context, lngObject, METHOD_NAME_EXIT, param));
                supressExceptions.set(supressExceptions.get() || exitValue);
            }
            catch (Exception e) {
                closeExceptions.add(new RuntimeException(e));
            }
        }
    }
}

