/*
 * Decompiled with CFR 0.152.
 */
package ch.turic.memory;

import ch.turic.ExecutionException;
import ch.turic.memory.HasFields;
import java.lang.reflect.Field;
import java.lang.runtime.SwitchBootstraps;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public record JavaObject(Object object) implements HasFields
{
    @Override
    public void setField(String name, Object value) {
        Object object = this.object;
        if (object instanceof HasFields) {
            HasFields fielder = (HasFields)object;
            fielder.setField(name, value);
            return;
        }
        try {
            Field field = this.object.getClass().getField(name);
            field.set(this.object, value);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new ExecutionException("Cannot set the value of the field '" + name + "' ", new Object[]{e});
        }
    }

    @Override
    public Object getField(String name) throws ExecutionException {
        Object object = this.object;
        if (object instanceof HasFields) {
            HasFields fielder = (HasFields)object;
            return fielder.getField(name);
        }
        try {
            Field field = this.object.getClass().getField(name);
            return field.get(this.object);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new ExecutionException("Cannot get '%s.%s' because '%s'.", this.object, name, e);
        }
    }

    @Override
    public Set<String> fields() {
        return Arrays.stream(this.object.getClass().getDeclaredFields()).map(Field::getName).collect(Collectors.toSet());
    }

    @Override
    public String toString() {
        if (this.object == null) {
            return "null";
        }
        Object object = this.object;
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{String.class, Character.class}, (Object)object2, n)) {
            case 0 -> {
                String s = (String)object2;
                yield "\"" + s + "\"";
            }
            case 1 -> {
                Character c = (Character)object2;
                yield "'" + c + "'";
            }
            default -> this.object.toString();
        };
    }
}

