/*
 * Decompiled with CFR 0.152.
 */
package ch.turic.memory;

import ch.turic.ExecutionException;
import ch.turic.analyzer.Pos;
import ch.turic.commands.AbstractCommand;
import ch.turic.memory.Context;
import ch.turic.memory.LngClass;
import ch.turic.memory.LngList;
import ch.turic.memory.LngObject;
import ch.turic.memory.LngStackFrame;
import java.util.List;
import java.util.Set;

public class LngException
extends LngObject {
    private static final LngClass exceptionClass = new LngClass(null, "EXCEPTION");
    private final Throwable e;
    private final LngList stackTrace;
    private final Context context;

    public LngException(Context context, Throwable e, List<LngStackFrame> stackTrace) {
        super(exceptionClass, null);
        this.context = context;
        this.e = e;
        this.stackTrace = new LngList();
        int index = 0;
        for (LngStackFrame st : stackTrace.reversed()) {
            LngObject tr = new LngObject(null, this.context().open());
            AbstractCommand command = st.command();
            tr.setField("command", command.getClass().getSimpleName());
            Pos position = command.startPosition();
            if (position != null) {
                tr.setField("file", position.file);
                tr.setField("line", position.line);
                tr.setField("column", position.column);
                tr.setField("source", position.lines[position.line - 1]);
            } else {
                tr.setField("file", "-");
                tr.setField("line", 0);
                tr.setField("column", 0);
                tr.setField("source", "");
            }
            this.stackTrace.setIndex(index++, tr);
        }
    }

    public static LngException build(Context context, Throwable e, List<LngStackFrame> stackTrace) {
        ExecutionException ee;
        if (e instanceof ExecutionException && (ee = (ExecutionException)e).embedded() != null) {
            return ee.embedded();
        }
        return new LngException(context, e, stackTrace);
    }

    public Throwable getCause() {
        return this.e;
    }

    @Override
    public Context context() {
        return this.context;
    }

    @Override
    public Object getIndex(Object index) throws ExecutionException {
        throw new ExecutionException("Exeptions do not have index.", new Object[0]);
    }

    @Override
    public LngClass lngClass() {
        return exceptionClass;
    }

    @Override
    public void setField(String name, Object value) {
        throw new ExecutionException("Exeptions are immutable.", new Object[0]);
    }

    @Override
    public void setIndex(Object index, Object value) throws ExecutionException {
        super.setIndex(index, value);
    }

    @Override
    public Object getField(String name) throws ExecutionException {
        return switch (name) {
            case "stack_trace" -> this.stackTrace;
            case "message" -> this.e.getMessage();
            case "cause" -> LngException.build(this.context, this.e.getCause(), this.context.threadContext.getStackTrace());
            case "suppressed" -> {
                LngList lngList = new LngList();
                Throwable[] suppressed = this.e.getSuppressed();
                for (int i = 0; i < suppressed.length; ++i) {
                    lngList.setIndex(i, suppressed[i]);
                }
                yield lngList;
            }
            default -> null;
        };
    }

    @Override
    public Set<String> fields() {
        return Set.of("message", "stack_trace", "cause", "supressed");
    }

    @Override
    public String toString() {
        if (this.e == null) {
            return "none";
        }
        return this.e.getMessage();
    }
}

