/*
 * Decompiled with CFR 0.152.
 */
package ch.turic.memory;

import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;

public class ResizableSemaphore
extends Semaphore {
    private final AtomicInteger inUse = new AtomicInteger(0);
    private volatile int maxPermits;

    public ResizableSemaphore(int initialPermits, boolean fair) {
        super(initialPermits, fair);
        this.maxPermits = initialPermits;
        super.release(initialPermits);
    }

    @Override
    protected void reducePermits(int permits) {
        super.reducePermits(permits);
    }

    public synchronized void setLimit(int newLimit) {
        int delta = newLimit - this.maxPermits;
        this.maxPermits = newLimit;
        if (delta > 0) {
            super.release(delta);
        } else if (delta < 0) {
            this.reducePermits(-delta);
        }
    }

    public Permit acquirePermit() throws InterruptedException {
        super.acquire();
        this.inUse.incrementAndGet();
        return new Permit();
    }

    public int getInUse() {
        return this.inUse.get();
    }

    public int getLimit() {
        return this.maxPermits;
    }

    public class Permit
    implements AutoCloseable {
        private boolean released = false;

        @Override
        public void close() {
            if (!this.released) {
                this.released = true;
                ResizableSemaphore.this.inUse.decrementAndGet();
                ResizableSemaphore.super.release(1);
            }
        }
    }
}

