/*
 * Decompiled with CFR 0.152.
 */
package ch.turic.cli;

import ch.turic.Input;
import ch.turic.Interpreter;
import ch.turic.Program;
import ch.turic.cli.CmdParser;
import ch.turic.cli.JLineRepl;
import ch.turic.commands.operators.Cast;
import ch.turic.utils.Marshaller;
import ch.turic.utils.Unmarshaller;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Set;

public class Main {
    static final Set<String> parameters = Set.of("version", "APPIA", "compile", "REPL", "help");

    public static void main(String[] args) throws IOException {
        CmdParser params = CmdParser.parse(args, parameters);
        if (params.get("version").isPresent()) {
            String buildTime = new String(Main.class.getResourceAsStream("/buildtime.txt").readAllBytes(), StandardCharsets.UTF_8);
            String version = Main.class.getPackage().getImplementationVersion();
            if (version == null) {
                version = "DEV-SNAPSHOT";
            }
            System.out.printf("Turicum Version %s (Built: %s)\n", version, buildTime);
            return;
        }
        if (params.get("help").isPresent()) {
            System.out.println("Usage: turi [options] program [arguments]\n  -help                      help\n  -version                   display version\n  -APPIA=<import path>       list of directories looking for files when importing\n  -compile                   compile only\n  -REPL                      start REPL");
            return;
        }
        if (params.get("REPL").isPresent()) {
            JLineRepl.execute();
            return;
        }
        if (params.get(0).isEmpty()) {
            throw new IllegalArgumentException("You must specify a program to run");
        }
        String inputFile = params.get(0).get();
        if (params.get("APPIA").isPresent()) {
            System.setProperty("APPIA", params.get("APPIA").get());
        }
        try {
            Interpreter interpreter;
            if (inputFile.endsWith(".turi")) {
                interpreter = new Interpreter((Input)((ch.turic.analyzer.Input)Input.fromFile((Path)Path.of(inputFile, new String[0]))));
            } else if (inputFile.endsWith(".turc")) {
                if (params.get("compile").isPresent()) {
                    System.out.println("'.turc' files are already compiled");
                    return;
                }
                byte[] bytes = Files.readAllBytes(Path.of(inputFile, new String[0]));
                Unmarshaller unmarshaller = new Unmarshaller();
                Program code = unmarshaller.deserialize(bytes);
                interpreter = new Interpreter(code);
            } else {
                System.out.println("The program file name has to end with '.turi' or '.turc'");
                return;
            }
            if (params.get("compile").isPresent()) {
                Program program = interpreter.compile();
                Marshaller marshaller = new Marshaller();
                byte[] bytes = marshaller.serialize(program);
                String outputFile = inputFile.substring(0, inputFile.length() - 5) + ".turc";
                Files.write(Path.of(outputFile, new String[0]), bytes, new OpenOption[0]);
                return;
            }
            Object returnValue = interpreter.compileAndExecute();
            if (returnValue != null && Cast.isLong((Object)returnValue)) {
                System.exit(Cast.toLong((Object)returnValue).intValue());
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            System.exit(1);
        }
    }
}

