/*
 * Decompiled with CFR 0.152.
 */
package ch.turic.analyzer;

import ch.turic.BadSyntax;
import ch.turic.Command;
import ch.turic.analyzer.AbstractAnalyzer;
import ch.turic.analyzer.LexList;
import ch.turic.analyzer.UnaryExpressionAnalyzer;
import ch.turic.commands.Operation;
import java.util.Arrays;

public class BinaryExpressionAnalyzer
extends AbstractAnalyzer {
    final String[][] binops;
    static final String[][] binaryOperators = new String[][]{{"or"}, {"||"}, {"&&"}, {".."}, {"|"}, {"^"}, {"&"}, {"===", "==", "!=", "in"}, {"<", "<=", ">", ">="}, {"<<", ">>", ">>>"}, {"+", "-"}, {"*", "/", "%"}, {"**"}};
    static final BinaryExpressionAnalyzer INSTANCE = new BinaryExpressionAnalyzer(binaryOperators);
    static final BinaryExpressionAnalyzer BINARY_DEFAULT_EXPRESSION_ANALYZER = new BinaryExpressionAnalyzer((String[][])Arrays.copyOf(binaryOperators, binaryOperators.length));
    private final int N;

    public BinaryExpressionAnalyzer(String[][] binops) {
        this.binops = binops;
        this.N = binops.length;
    }

    public Command analyze(int precedenceLevel, LexList lexes) throws BadSyntax {
        if (lexes.isEmpty()) {
            throw lexes.syntaxError("Expression is empty", new Object[0]);
        }
        if (precedenceLevel == this.N) {
            return UnaryExpressionAnalyzer.INSTANCE.analyze(lexes);
        }
        Command left = this.analyze(precedenceLevel + 1, lexes);
        while (lexes.is(this.binops[precedenceLevel])) {
            String op = lexes.next().text();
            Command right = this.analyze(precedenceLevel + 1, lexes);
            left = new Operation(op, left, right);
        }
        return left;
    }

    @Override
    public Command _analyze(LexList lexes) throws BadSyntax {
        return this.analyze(0, lexes);
    }

    static {
        BinaryExpressionAnalyzer.BINARY_DEFAULT_EXPRESSION_ANALYZER.binops[4] = new String[0];
    }
}

