/*
 * Decompiled with CFR 0.152.
 */
package ch.turic.analyzer;

import ch.turic.BadSyntax;
import ch.turic.Command;
import ch.turic.analyzer.ExpressionAnalyzer;
import ch.turic.analyzer.LexList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class OptionListAnalyzer {
    public static Map<String, Command> analyze(LexList lexes, Set<String> acceptedParameters) throws BadSyntax {
        HashMap<String, Command> map = new HashMap<String, Command>();
        if (lexes.is("]")) {
            return Map.of();
        }
        if (acceptedParameters.size() == 1 && !lexes.isIdentifier()) {
            Command expression = ExpressionAnalyzer.INSTANCE.analyze(lexes);
            for (String key : acceptedParameters) {
                map.put(key, expression);
            }
            return map;
        }
        while (lexes.isIdentifier() || lexes.isKeyword()) {
            String id = lexes.next().text();
            if (acceptedParameters.contains(id)) {
                BadSyntax.when(lexes, map.containsKey(id), "The key '%s' is double defined", id);
                BadSyntax.when(lexes, lexes.isNot("="), "The '=' is missing after an async option", new Object[0]);
                lexes.next();
                Command expression = ExpressionAnalyzer.INSTANCE.analyze(lexes);
                map.put(id, expression);
                continue;
            }
            throw lexes.syntaxError("'%s' is not an accepted parameter", id);
        }
        return map;
    }
}

