/*
 * Decompiled with CFR 0.152.
 */
package ch.turic.analyzer;

import ch.turic.BadSyntax;
import ch.turic.analyzer.Escape;
import ch.turic.analyzer.Input;

public class StringFetcher {
    public static final String MULTI_LINE_STRING_DELIMITER = "\"\"\"";
    private static final int MLSD_LENGTH = "\"\"\"".length();
    private static final char ENCLOSING_CH = '\"';
    private static final char IDENTIFIER_CH = '`';

    public static String getString(Input input) throws BadSyntax {
        BadSyntax.when(input.position, input.length() < 2, "String has to be at least two characters long.", new Object[0]);
        if (input.length() >= MLSD_LENGTH && input.subSequence(0, MLSD_LENGTH).equals(MULTI_LINE_STRING_DELIMITER)) {
            return StringFetcher.getMultiLineString(input);
        }
        return StringFetcher.getSimpleString(input);
    }

    private static String getMultiLineString(Input in) throws BadSyntax {
        StringBuilder output = new StringBuilder();
        in.skip(MLSD_LENGTH);
        while (in.length() >= MLSD_LENGTH && !in.subSequence(0, MLSD_LENGTH).equals(MULTI_LINE_STRING_DELIMITER)) {
            char ch = in.charAt(0);
            if (ch == '\\') {
                Escape.handleEscape(in, output);
                continue;
            }
            Escape.handleNormalMultiLineStringCharacter(in, output);
        }
        BadSyntax.when(in.position, in.length() < MLSD_LENGTH, "Multi-line string is not terminated before eof", new Object[0]);
        in.skip(MLSD_LENGTH);
        return output.toString();
    }

    private static String getSimpleString(Input in) throws BadSyntax {
        StringBuilder output = new StringBuilder();
        in.skip(1);
        while (!in.isEmpty() && in.charAt(0) != '\"') {
            char ch = in.charAt(0);
            if (ch == '\\') {
                Escape.handleEscape(in, output);
                continue;
            }
            Escape.handleNormalCharacter(in, output);
        }
        BadSyntax.when(in.position, in.isEmpty(), "String is not terminated before eol", new Object[0]);
        in.skip(1);
        return output.toString();
    }

    public static String fetchId(Input in) throws BadSyntax {
        StringBuilder output = new StringBuilder();
        in.skip(1);
        while (!in.isEmpty() && in.charAt(0) != '`') {
            char ch = in.charAt(0);
            if (ch == '\\') {
                Escape.handleEscape(in, output);
                continue;
            }
            Escape.handleNormalCharacter(in, output);
        }
        BadSyntax.when(in.position, in.isEmpty(), "String is not terminated before eol", new Object[0]);
        in.skip(1);
        return output.toString();
    }
}

