/*
 * Decompiled with CFR 0.152.
 */
package ch.turic.analyzer;

import ch.turic.BadSyntax;
import ch.turic.Command;
import ch.turic.analyzer.AbstractAnalyzer;
import ch.turic.analyzer.BlockAnalyzer;
import ch.turic.analyzer.CommandAnalyzer;
import ch.turic.analyzer.LexList;
import ch.turic.commands.BlockCommand;
import ch.turic.commands.TryCatch;
import java.util.Objects;

public class TryCatchAnalyzer
extends AbstractAnalyzer {
    public static final TryCatchAnalyzer INSTANCE = new TryCatchAnalyzer();

    @Override
    public TryCatch _analyze(LexList lexes) throws BadSyntax {
        Command finallyBlock;
        Command catchCommand;
        String exception;
        Command tryCommand = this.getCommand(lexes, "try");
        if (lexes.is("catch")) {
            lexes.next();
            exception = this.getExceptionVariableIdentifier(lexes);
            catchCommand = this.getCommand(lexes, "catch");
        } else {
            catchCommand = null;
            exception = null;
        }
        if (lexes.is("finally")) {
            lexes.next();
            finallyBlock = this.getCommand(lexes, "finally");
        } else {
            finallyBlock = null;
        }
        return new TryCatch(tryCommand, catchCommand, finallyBlock, exception);
    }

    private String getExceptionVariableIdentifier(LexList lexes) {
        boolean usesParen = lexes.is("(");
        if (usesParen) {
            lexes.next();
        }
        if (lexes.isIdentifier()) {
            String exception = lexes.next().text;
            if (usesParen) {
                BadSyntax.when(lexes, lexes.isNot(")"), "Missing ')' after the exception ", new Object[0]);
                lexes.next();
            }
            return exception;
        }
        return null;
    }

    private Command getCommand(LexList lexes, String msg) throws BadSyntax {
        Command command;
        if (lexes.is("{")) {
            command = BlockAnalyzer.INSTANCE.analyze(lexes);
        } else if (lexes.is(":")) {
            lexes.next();
            command = Objects.requireNonNullElse(CommandAnalyzer.INSTANCE.analyze(lexes), BlockCommand.EMPTY_BLOCK);
        } else {
            throw lexes.syntaxError(": or {", "Expected ':' or '{'");
        }
        return command;
    }
}

