/*
 * Decompiled with CFR 0.152.
 */
package ch.turic.builtins.classes;

import ch.turic.Context;
import ch.turic.ExecutionException;
import ch.turic.LngCallable;
import java.util.function.Supplier;

public class TuriMethod<T>
implements LngCallable.LngCallableClosure {
    private final T target;
    private final BiFunction<T, Object[], T> method;

    public TuriMethod(T target, BiFunction<T, Object[], T> method) {
        this.target = target;
        this.method = method;
    }

    public TuriMethod(Function<Object[], T> method) {
        this(null, (target, args) -> method.apply((Object[])args));
    }

    public TuriMethod(Supplier<T> method) {
        this(null, (target, args) -> {
            if (args != null && ((Object[])args).length > 0) {
                throw new ExecutionException("Too many arguments", new Object[0]);
            }
            return method.get();
        });
    }

    public static <T> TuriMethod<T> of(Supplier<T> method) {
        return new TuriMethod<T>(method);
    }

    @Override
    public Object call(Context ctx, Object[] arguments) throws ExecutionException {
        try {
            return this.method.apply(this.target, arguments);
        }
        catch (Exception e) {
            throw new ExecutionException(e);
        }
    }

    public static interface BiFunction<T, U, R> {
        public R apply(T var1, U var2) throws Exception;
    }

    public static interface Function<T, R> {
        public R apply(T var1) throws Exception;
    }
}

