/*
 * Decompiled with CFR 0.152.
 */
package ch.turic.commands;

import ch.turic.Command;
import ch.turic.ExecutionException;
import ch.turic.commands.AbstractCommand;
import ch.turic.commands.operators.Operator;
import ch.turic.memory.Context;
import ch.turic.memory.LeftValue;
import ch.turic.utils.Unmarshaller;
import java.util.Objects;
import java.util.function.Function;

public class Assignment
extends AbstractCommand {
    final LeftValue leftValue;
    final Command expression;
    final String op;

    public Command expression() {
        return this.expression;
    }

    public LeftValue leftValue() {
        return this.leftValue;
    }

    public static Assignment factory(Unmarshaller.Args args) {
        return new Assignment(args.get("leftValue", LeftValue.class), args.str("op"), args.command("expression"));
    }

    public Assignment(LeftValue leftValue, String op, Command expression) {
        this.expression = expression;
        this.op = Objects.requireNonNull(op);
        this.leftValue = leftValue;
    }

    @Override
    public Object _execute(Context ctx) throws ExecutionException {
        ctx.step();
        if (this.op.isEmpty()) {
            Object value = this.expression.execute(ctx);
            this.leftValue.assign(ctx, value);
            return value;
        }
        return this.leftValue.reassign(ctx, this.getOperation(this.op, ctx));
    }

    Function<Object, Object> getOperation(String operator, Context ctx) {
        if (Operator.OPERATORS.containsKey(operator)) {
            Operator op = Operator.OPERATORS.get(operator);
            return oldValue -> op.execute(ctx, context -> oldValue, this.expression);
        }
        throw new ExecutionException("Unknown operator " + operator, new Object[0]);
    }
}

