/*
 * Decompiled with CFR 0.152.
 */
package ch.turic.commands;

import ch.turic.Command;
import ch.turic.ExecutionException;
import ch.turic.Input;
import ch.turic.analyzer.BlockAnalyzer;
import ch.turic.analyzer.LexList;
import ch.turic.analyzer.Lexer;
import ch.turic.commands.AbstractCommand;
import ch.turic.memory.Context;
import ch.turic.utils.Unmarshaller;
import java.util.ArrayList;
import java.util.Objects;

public class StringConstant
extends AbstractCommand {
    private final String value;
    private final Command[] commands;

    public static StringConstant factory(Unmarshaller.Args args) {
        return new StringConstant(args.str("value"), args.commands());
    }

    public String value() {
        return this.value;
    }

    private StringConstant(String value, Command[] commands) {
        this.value = value;
        this.commands = commands;
    }

    public StringConstant(String value, boolean interpolated) {
        Objects.requireNonNull(value);
        if (interpolated) {
            int i;
            String[] parts = StringConstant.split(value);
            this.commands = new Command[parts.length];
            for (i = 0; i < parts.length; i += 2) {
                this.commands[i] = new StringConstant(parts[i], false);
            }
            for (i = 1; i < parts.length; i += 2) {
                LexList lexes = Lexer.analyze((ch.turic.analyzer.Input)Input.fromString(parts[i]));
                this.commands[i] = lexes.is("(") ? BlockAnalyzer.FLAT.analyze(lexes) : BlockAnalyzer.INSTANCE.analyze(lexes);
            }
            this.value = null;
        } else {
            this.value = value;
            this.commands = null;
        }
    }

    private static String[] split(String str) {
        int start = 0;
        int end = 0;
        ArrayList<String> parts = new ArrayList<String>();
        boolean inLiteral = true;
        int pCounter = 0;
        int bCounter = 0;
        int terminator = 0;
        while (end < str.length()) {
            if (inLiteral) {
                if (str.charAt(end) == '$' && end + 1 < str.length() && ((terminator = str.charAt(end + 1)) == 123 || terminator == 40)) {
                    parts.add(str.substring(start, end));
                    start = ++end;
                    inLiteral = false;
                    if (terminator == 123) {
                        --bCounter;
                        terminator = 125;
                        continue;
                    }
                    --pCounter;
                    terminator = 41;
                    continue;
                }
            } else {
                if (str.charAt(end) == terminator && pCounter == 0 && bCounter == 0) {
                    parts.add(str.substring(start, ++end));
                    start = end;
                    inLiteral = true;
                    terminator = 0;
                    continue;
                }
                switch (str.charAt(end)) {
                    case '(': {
                        ++pCounter;
                        break;
                    }
                    case ')': {
                        --pCounter;
                        break;
                    }
                    case '{': {
                        ++bCounter;
                        break;
                    }
                    case '}': {
                        --bCounter;
                        break;
                    }
                }
            }
            ++end;
        }
        if (pCounter != 0) {
            throw new ExecutionException("Invalid string constant syntax, unbalanced '(' and ')' character(s)", new Object[0]);
        }
        if (bCounter != 0) {
            throw new ExecutionException("Invalid string constant syntax, unbalanced '{' and '}' character(s)", new Object[0]);
        }
        if (!inLiteral) {
            throw new ExecutionException("Invalid string constant syntax, unclosed interpolated expression.", new Object[0]);
        }
        parts.add(str.substring(start, end));
        return (String[])parts.toArray(String[]::new);
    }

    @Override
    public String _execute(Context context) throws ExecutionException {
        if (this.commands == null) {
            return this.value;
        }
        StringBuilder sb = new StringBuilder();
        for (Command command : this.commands) {
            sb.append((Object)Objects.requireNonNullElse(command.execute(context), "none"));
        }
        return sb.toString();
    }
}

