/*
 * Decompiled with CFR 0.152.
 */
package ch.turic.memory;

import ch.turic.Command;
import ch.turic.ExecutionException;
import ch.turic.memory.Context;
import ch.turic.memory.HasFields;
import ch.turic.memory.HasIndex;
import ch.turic.memory.IndexedString;
import ch.turic.memory.LeftValue;
import ch.turic.memory.LngObject;
import ch.turic.utils.Unmarshaller;
import java.util.Objects;
import java.util.function.Function;

public record ArrayElementLeftValue(LeftValue arrayLeftValue, Command index) implements LeftValue
{
    public ArrayElementLeftValue {
        Objects.requireNonNull(index);
    }

    public static ArrayElementLeftValue factory(Unmarshaller.Args args) {
        return new ArrayElementLeftValue(args.get("arrayLeftValue", LeftValue.class), args.command("index"));
    }

    @Override
    public HasFields getObject(Context ctx) {
        Object indexValue = this.index.execute(ctx);
        HasIndex guaranteedObject = this.arrayLeftValue.getIndexable(ctx, indexValue);
        Object existing = guaranteedObject.getIndex(indexValue);
        if (existing == null) {
            LngObject newObject = LngObject.newEmpty(ctx);
            guaranteedObject.setIndex(indexValue, newObject);
            return newObject;
        }
        return LeftValue.toObject(existing);
    }

    @Override
    public HasIndex getIndexable(Context ctx, Object indexValue) {
        Object leftValueIndex = this.index.execute(ctx);
        HasIndex guaranteedObject = this.arrayLeftValue.getIndexable(ctx, leftValueIndex);
        Object existing = guaranteedObject.getIndex(leftValueIndex);
        if (existing == null) {
            HasIndex newIndexable = HasIndex.createFor(indexValue, ctx);
            guaranteedObject.setIndex(leftValueIndex, newIndexable);
            return newIndexable;
        }
        return LeftValue.toIndexable(existing);
    }

    @Override
    public void assign(Context ctx, Object value) throws ExecutionException {
        Object indexValue = this.index.execute(ctx);
        HasIndex indexable = this.arrayLeftValue.getIndexable(ctx, indexValue);
        indexable.setIndex(indexValue, value);
        this.updateString(ctx, indexable);
    }

    @Override
    public Object reassign(Context ctx, Function<Object, Object> newValueCalculator) throws ExecutionException {
        Object indexValue = this.index.execute(ctx);
        HasIndex indexable = this.arrayLeftValue.getIndexable(ctx, indexValue);
        Object value = indexable.getIndex(indexValue);
        Object newValue = newValueCalculator.apply(value);
        indexable.setIndex(indexValue, newValue);
        this.updateString(ctx, indexable);
        return newValue;
    }

    private void updateString(Context ctx, HasIndex indexable) {
        if (indexable instanceof IndexedString) {
            StringBuilder string;
            IndexedString indexedString = (IndexedString)indexable;
            try {
                StringBuilder stringBuilder;
                string = stringBuilder = indexedString.string();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            this.arrayLeftValue.assign(ctx, string.toString());
        }
    }

    @Override
    public String toString() {
        return this.arrayLeftValue.toString() + "[" + this.index.toString() + "]";
    }
}

