/*
 * Decompiled with CFR 0.152.
 */
package ch.turic.memory;

import ch.turic.ExecutionException;
import ch.turic.memory.GlobalContext;
import ch.turic.memory.ThreadContext;
import ch.turic.memory.Variable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Context
implements ch.turic.Context {
    Map<String, Variable> frame;
    private final Set<String> globals = new HashSet<String>();
    private final Set<String> nonlocal = new HashSet<String>();
    private final Set<String> frozen;
    private final Context wrapped;
    public final GlobalContext globalContext;
    public final ThreadContext threadContext;
    public Context caller = null;
    private final List<String> exporting = new ArrayList<String>();
    private final boolean shadow;
    private final boolean with;
    private boolean pinned = false;

    public Set<String> keys() {
        return this.frame.keySet();
    }

    public Set<String> allKeys() {
        HashSet<String> keySet = new HashSet<String>();
        keySet.addAll(this.allLocalKeys());
        keySet.addAll(this.globalContext.heap.keySet());
        return keySet;
    }

    public Set<String> allLocalKeys() {
        HashSet<String> keySet = new HashSet<String>();
        Context ctx = this;
        while (ctx != null) {
            keySet.addAll(ctx.frame.keySet());
            ctx = ctx.wrapped;
        }
        return keySet;
    }

    public Set<String> allFrameKeys() {
        return new HashSet<String>(this.frame.keySet());
    }

    public Context() {
        this(-1);
    }

    public Context(int stepLimit) {
        this.globalContext = new GlobalContext(stepLimit, this);
        this.wrapped = null;
        this.frame = this.globalContext.heap;
        this.threadContext = new ThreadContext();
        this.shadow = false;
        this.with = false;
        this.frozen = new HashSet<String>();
    }

    public Context(GlobalContext globalContext, ThreadContext threadContext) {
        this.wrapped = null;
        this.frame = new HashMap<String, Variable>();
        this.globalContext = globalContext;
        this.threadContext = threadContext;
        this.shadow = false;
        this.with = false;
        this.frozen = new HashSet<String>();
    }

    private Context(Context clone, Context wrapped) {
        this.globalContext = clone.globalContext;
        this.threadContext = clone.threadContext;
        this.frame = new HashMap<String, Variable>();
        this.wrapped = wrapped;
        this.shadow = false;
        this.with = false;
        this.frozen = new HashSet<String>();
    }

    private Context(Context thisContext, Context wrappedContext, boolean shadow) {
        this.globalContext = thisContext.globalContext;
        this.threadContext = thisContext.threadContext;
        this.frame = new HashMap<String, Variable>();
        this.wrapped = wrappedContext;
        this.shadow = shadow;
        this.with = false;
        this.frozen = new HashSet<String>();
    }

    private Context(Context thisContext, Context wrappedContext, Context withContext) {
        this.globalContext = thisContext.globalContext;
        this.threadContext = thisContext.threadContext;
        this.frame = withContext.frame;
        this.frozen = withContext.frozen;
        this.wrapped = wrappedContext;
        this.shadow = false;
        this.with = true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void freeze(String identifier) {
        ExecutionException.when(this.frozen.contains(identifier), "variable is already pinned '" + identifier + "'", new Object[0]);
        if (!this.contains(identifier)) {
            throw new ExecutionException("variable '" + identifier + "' is not defined, cannot be pinned", new Object[0]);
        }
        if (this.with) {
            if (this.containsFrame(identifier)) {
                this.frozen.add(identifier);
                return;
            } else {
                if (this.wrapped == null) throw new ExecutionException("variable '" + identifier + "' is defined, but not found in freeze. It is an internal error.", new Object[0]);
                this.wrapped.freeze(identifier);
            }
            return;
        } else {
            this.frozen.add(identifier);
        }
    }

    public void define(String key, Object value, String[] typeNames) {
        Variable v = this.createVariable(key, typeNames);
        v.value = value;
        this.frame.put(key, v);
    }

    public void defineTypeChecked(String key, Object value, String[] typeNames) {
        Variable v = this.createVariable(key, typeNames);
        v.set(value);
    }

    private Variable createVariable(String key, String[] typeNames) {
        ExecutionException.when(this.globals.contains(key), "Local variable is already defined as global '" + key + "'", new Object[0]);
        ExecutionException.when(this.nonlocal.contains(key), "Variable cannot be local, it is already used as non-local '" + key + "'", new Object[0]);
        ExecutionException.when(this.frozen.contains(key), "final variable cannot be altered '" + key + "'", new Object[0]);
        if (this.frame.containsKey(key)) {
            throw new ExecutionException("Variable '%s' is already defined.", key);
        }
        if (this.shadow) {
            Context ctx = this;
            while (ctx != null && ctx.shadow) {
                ctx = ctx.wrapped;
                if (ctx == null || !ctx.frame.containsKey(key)) continue;
                throw new ExecutionException("Variable '%s' is already defined.", key);
            }
        }
        Variable v = new Variable(key);
        v.types = Variable.getTypes(this, typeNames);
        this.frame.put(key, v);
        return v;
    }

    public void unlet(String key) throws ExecutionException {
        ExecutionException.when(!this.frame.containsKey(key), "Variable '%s' is not defined in the local context you cannot unlet '%s'", key);
        this.frame.remove(key);
        this.frozen.remove(key);
        this.globals.remove(key);
        this.nonlocal.remove(key);
    }

    public void mergeVariablesFrom(Context ctx, Set<String> exceptions) throws ExecutionException {
        for (Map.Entry<String, Variable> e : ctx.frame.entrySet()) {
            String key = e.getKey();
            Variable value = e.getValue();
            if (exceptions.contains(key)) continue;
            if (this.frame.containsKey(key)) {
                Variable v = this.frame.get(key);
                ArrayList<Variable.Type> types = new ArrayList<Variable.Type>(v.types.length + value.types.length);
                for (Variable.Type t : v.types) {
                    if (!this.isNewType(types, t)) continue;
                    types.add(t);
                }
                for (Variable.Type t : value.types) {
                    if (!this.isNewType(types, t)) continue;
                    types.add(t);
                }
                v.types = (Variable.Type[])types.toArray(Variable.Type[]::new);
                v.set(value.value);
                continue;
            }
            this.frame.put(key, value);
        }
    }

    private boolean isNewType(List<Variable.Type> types, Variable.Type type) {
        for (Variable.Type t : types) {
            if (!t.equals(type)) continue;
            return false;
        }
        return true;
    }

    public void local(String key, Object value) throws ExecutionException {
        ExecutionException.when(this.globals.contains(key), "Local variable is already defined as global '" + key + "'", new Object[0]);
        ExecutionException.when(this.nonlocal.contains(key), "Variable cannot be local, it is already used as non-local '" + key + "'", new Object[0]);
        ExecutionException.when(this.frozen.contains(key), "pinned variable cannot be altered '" + key + "'", new Object[0]);
        this.frame.computeIfAbsent(key, x -> new Variable(key)).set(value);
    }

    public void global(String global) throws ExecutionException {
        ExecutionException.when(this.frame != this.globalContext.heap && this.frame.containsKey(global), "Global variable '%s' is already defined as local.", global);
        this.globals.add(global);
    }

    public void global(String global, Object value) throws ExecutionException {
        this.global(global);
        this.globalContext.heap.computeIfAbsent(global, Variable::new).set(value);
    }

    public Context open() {
        return new Context(this, null);
    }

    public Context with(Context other) {
        return new Context(this, this, other);
    }

    public Context thread() {
        return new Context(this.globalContext, new ThreadContext());
    }

    public Context wrap() {
        return new Context(this, this);
    }

    public Context shadow() {
        return new Context(this, this, true);
    }

    public Context wrap(Context wrapped) {
        return new Context(this, wrapped);
    }

    public void update(String key, Object value) {
        if (this.globals.contains(key)) {
            this.globalContext.heap.computeIfAbsent(key, Variable::new).set(value);
            return;
        }
        for (Context ctx : this.wrappingContexts()) {
            if (ctx.frozen.contains(key)) {
                throw new ExecutionException("Variable '%s' is pinned.", key);
            }
            if (!ctx.frame.containsKey(key)) continue;
            if (ctx.pinned) {
                throw new ExecutionException("Variable '%s' is in a pinned context.", key);
            }
            if (ctx != this) {
                this.nonlocal.add(key);
            }
            ctx.frame.computeIfAbsent(key, Variable::new).set(value);
            return;
        }
        ExecutionException.when(this.nonlocal.contains(key), "Variable '%s' was used as global, but is not declared, cannot be changed.", key);
        throw new ExecutionException("Variable '%s' is not defined.", key);
    }

    public List<Context> wrappingContexts() {
        ArrayList<Context> ctxList = new ArrayList<Context>();
        ctxList.add(this);
        if (this.wrapped != null) {
            ctxList.addAll(this.wrapped.wrappingContexts());
        }
        return ctxList;
    }

    public ContextLock lock() {
        this.pinned = true;
        return new ContextLock();
    }

    public void let0(String key, Object value) {
        this.frame.computeIfAbsent(key, Variable::new).set(value);
    }

    public Object get(String key) {
        if (this.globals.contains(key)) {
            Variable variable = this.globalContext.heap.get(key);
            if (variable == null) {
                return null;
            }
            return variable.get();
        }
        Context ctx = this;
        while (ctx != null) {
            if (ctx.frame.containsKey(key)) {
                if (ctx != this) {
                    this.nonlocal.add(key);
                }
                return ctx.frame.get(key).get();
            }
            ctx = ctx.wrapped;
        }
        if (this.globalContext.heap.containsKey(key)) {
            this.nonlocal.add(key);
            return this.globalContext.heap.get(key).get();
        }
        throw new ExecutionException("Variable '%s' is undefined.", key);
    }

    public boolean contains(String key) {
        if (this.frame.containsKey(key)) {
            return true;
        }
        if (this.wrapped != null && this.wrapped.contains(key)) {
            return true;
        }
        return this.globalContext.heap.containsKey(key);
    }

    public boolean contains0(String key) {
        return this.frame.containsKey(key);
    }

    public boolean containsLocal(String key) {
        if (this.frame.containsKey(key)) {
            return true;
        }
        return this.wrapped != null && this.wrapped.containsLocal(key);
    }

    public boolean containsFrame(String key) {
        return this.frame.containsKey(key);
    }

    public Object getLocal(String key) {
        Context ctx = this;
        while (ctx != null) {
            if (ctx.frame.containsKey(key)) {
                return ctx.frame.get(key).get();
            }
            ctx = ctx.wrapped;
        }
        return null;
    }

    public void step() throws ExecutionException {
        this.globalContext.step();
    }

    public Context caller() {
        Context ctx = this;
        while (ctx.caller == null && ctx.wrapped != null) {
            ctx = ctx.wrapped;
        }
        return ctx.caller;
    }

    public void setCaller(Context caller) {
        this.caller = caller;
    }

    public List<String> exporting() {
        return this.exporting;
    }

    public void addExport(String exporting) {
        this.exporting.add(exporting);
    }

    public class ContextLock
    implements AutoCloseable {
        @Override
        public void close() {
            Context.this.pinned = false;
        }
    }
}

