/*
 * Decompiled with CFR 0.152.
 */
package ch.turic.memory;

import ch.turic.ExecutionException;
import ch.turic.commands.operators.Cast;
import ch.turic.memory.HasIndex;
import ch.turic.memory.InfiniteValue;
import ch.turic.memory.Range;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Iterator;

public record IndexedString(StringBuilder string) implements HasIndex
{
    public IndexedString(String s) {
        this(new StringBuilder(s));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void setIndex(Object index, Object value) throws ExecutionException {
        int end;
        int start;
        if (Cast.isLong(index)) {
            start = Cast.toLong(index).intValue();
            ExecutionException.when(start < 0 || start >= this.string.length(), "String indexing error, %d is out of array range", start);
            end = start + 1;
        } else {
            Object rangeEnd;
            Object rangeStart;
            if (!(index instanceof Range)) {
                throw new ExecutionException("Cannot use '%s' as index", index);
            }
            Range range = (Range)index;
            try {
                Object object;
                rangeStart = object = range.start();
                rangeEnd = object = range.end();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            start = IndexedString.getStart(this.string, rangeStart);
            end = IndexedString.getEnd(this.string, rangeEnd);
        }
        StringBuilder sb = new StringBuilder();
        if (start > 0) {
            sb.append(this.string, 0, start);
        }
        sb.append(value);
        if (end < this.string.length()) {
            sb.append(this.string, end, this.string.length());
        }
        this.string.setLength(0);
        this.string.append((CharSequence)sb);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object getIndex(Object index) throws ExecutionException {
        Object rangeEnd;
        Object rangeStart;
        int end;
        int start;
        if (Cast.isLong(index)) {
            start = Cast.toLong(index).intValue();
            ExecutionException.when(start < 0 || start >= this.string.length(), "String indexing error, %d is out of array range", start);
            end = start + 1;
            return this.string.substring(start, end);
        }
        if (!(index instanceof Range)) {
            throw new ExecutionException("Cannot use '%s' as index", index);
        }
        Range range = (Range)index;
        try {
            Object object;
            rangeStart = object = range.start();
            rangeEnd = object = range.end();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        start = IndexedString.getStart(this.string, rangeStart);
        end = IndexedString.getEnd(this.string, rangeEnd);
        return this.string.substring(start, end);
    }

    private static int getStart(StringBuilder string, Object rangeStart) {
        if (rangeStart == InfiniteValue.INF_NEGATIVE) {
            return IndexedString.inRange(string, 0);
        }
        if (Cast.isLong(rangeStart)) {
            return IndexedString.inRange(string, Cast.toLong(rangeStart).intValue());
        }
        throw new ExecutionException("Cannot use '%s' as index", rangeStart);
    }

    private static int getEnd(StringBuilder string, Object rangeStart) {
        if (rangeStart == InfiniteValue.INF_POSITIVE) {
            return string.length();
        }
        if (Cast.isLong(rangeStart)) {
            int end = Cast.toLong(rangeStart).intValue();
            if (end < 0) {
                return IndexedString.inRange(string, string.length() + end);
            }
            IndexedString.inRange(string, end - 1);
            return end;
        }
        throw new ExecutionException("Cannot use '%s' as index", rangeStart);
    }

    private static int inRange(StringBuilder string, int index) {
        ExecutionException.when(index < 0 || index >= string.length(), "String indexing error, %d is out of array range", index);
        return index;
    }

    @Override
    public Iterator<Object> iterator() {
        ArrayList<CallSite> strings = new ArrayList<CallSite>();
        for (char ch : this.string.toString().toCharArray()) {
            strings.add((CallSite)((Object)("" + ch)));
        }
        return strings.iterator();
    }
}

