/*
 * Decompiled with CFR 0.152.
 */
package ch.turic.memory;

import ch.turic.ExecutionException;
import ch.turic.commands.Closure;
import ch.turic.commands.Identifier;
import ch.turic.commands.Macro;
import ch.turic.commands.operators.Cast;
import ch.turic.memory.AsyncStreamHandler;
import ch.turic.memory.Channel;
import ch.turic.memory.Context;
import ch.turic.memory.LngClass;
import ch.turic.memory.LngException;
import ch.turic.memory.LngList;
import ch.turic.memory.LngObject;
import ch.turic.memory.NoneType;
import ch.turic.memory.SomeType;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;

public class Variable {
    public final String name;
    Object value;
    Type[] types;
    private static final Type[] NO_TYPE = new Type[0];

    public Variable(String name) {
        this.name = name;
    }

    public void set(Object newValue) throws ExecutionException {
        if (!Variable.isOfTypes(newValue, this.types)) {
            if (this.types.length == 1) {
                throw new ExecutionException("Cannot set variable '%s' to value '%s' because it does not fit the declared type %s", this.name, Objects.requireNonNullElse(newValue, "none"), this.types[0].toString());
            }
            throw new ExecutionException("Cannot set variable '%s' to value '%s' because it does not fit any of the declared types of the variable (%s)", this.name, Objects.requireNonNullElse(newValue, "none"), Arrays.stream(this.types).map(Type::toString).collect(Collectors.joining("|")));
        }
        this.value = newValue;
    }

    public static boolean isOfTypes(Object value, Type[] types) {
        if (types == null || types.length == 0) {
            return true;
        }
        for (Type type : types) {
            if (!Variable.isFit(value, type.javaType(), type.lngClass())) continue;
            return true;
        }
        return false;
    }

    public static Type[] getTypes(Context context, String[] names) {
        return names == null ? NO_TYPE : (Type[])Arrays.stream(names).map(s -> Variable.getTypeFromName(context, s)).toArray(Type[]::new);
    }

    public static Type getTypeFromName(Context context, String name) {
        return switch (name) {
            case "bool" -> {
                Type var4_4;
                yield var4_4 = new Type(Boolean.class, null, new Identifier(name));
            }
            case "str" -> {
                Type var4_5;
                yield var4_5 = new Type(String.class, null, new Identifier(name));
            }
            case "num" -> {
                Type var4_6;
                yield var4_6 = new Type(Long.class, null, new Identifier(name));
            }
            case "float" -> {
                Type var4_7;
                yield var4_7 = new Type(Double.class, null, new Identifier(name));
            }
            case "any" -> {
                Type var4_8;
                yield var4_8 = new Type(null, null, new Identifier(name));
            }
            case "obj" -> {
                Type var4_9;
                yield var4_9 = new Type(LngObject.class, null, new Identifier(name));
            }
            case "lst" -> {
                Type var4_10;
                yield var4_10 = new Type(LngList.class, null, new Identifier(name));
            }
            case "que" -> {
                Type var4_11;
                yield var4_11 = new Type(Channel.class, null, new Identifier(name));
            }
            case "task" -> {
                Type var4_12;
                yield var4_12 = new Type(AsyncStreamHandler.class, null, new Identifier(name));
            }
            case "err" -> {
                Type var4_13;
                yield var4_13 = new Type(LngException.class, null, new Identifier(name));
            }
            case "cls" -> {
                Type var4_14;
                yield var4_14 = new Type(LngClass.class, null, new Identifier(name));
            }
            case "fn" -> {
                Type var4_15;
                yield var4_15 = new Type(Closure.class, null, new Identifier(name));
            }
            case "macro" -> {
                Type var4_16;
                yield var4_16 = new Type(Macro.class, null, new Identifier(name));
            }
            case "none" -> {
                Type var4_17;
                yield var4_17 = new Type(NoneType.class, null, new Identifier(name));
            }
            case "some" -> {
                Type var4_18;
                yield var4_18 = new Type(SomeType.class, null, new Identifier(name));
            }
            default -> {
                if (name.startsWith("java.")) {
                    try {
                        Type var4_19;
                        yield var4_19 = new Type(Class.forName(name.substring(5)), null, new Identifier(name));
                    }
                    catch (ClassNotFoundException e) {
                        throw new ExecutionException("Type '%s' could not be found.", name);
                    }
                }
                if (context == null) {
                    throw new RuntimeException("Null context, internal error.");
                }
                ExecutionException.when(!context.contains(name), "Type '%s' is not defined.", name);
                Object classObject = context.get(name);
                if (classObject instanceof LngClass) {
                    Type var4_20;
                    LngClass lngClass = (LngClass)classObject;
                    yield var4_20 = new Type(LngObject.class, lngClass, new Identifier(name));
                }
                throw new ExecutionException("Type '%s' is not a class.", name);
            }
        };
    }

    public static boolean isFit(Object value, Class<?> javaType, LngClass lngClass) {
        if (javaType == null) {
            return true;
        }
        if (javaType == LngObject.class) {
            if (value instanceof LngObject) {
                LngObject lngObject = (LngObject)value;
                return lngObject.instanceOf(lngClass);
            }
            return false;
        }
        if (javaType == NoneType.class) {
            return value == null;
        }
        if (javaType == SomeType.class) {
            return value != null;
        }
        if (javaType == Double.class || javaType == Float.class) {
            return Cast.isDouble(value);
        }
        return value != null && javaType.isAssignableFrom(value.getClass());
    }

    public Object get() {
        return this.value;
    }

    public record Type(Class<?> javaType, LngClass lngClass, String declaration) {
        public Type(Class<?> javaType, LngClass lngClass, Identifier id) {
            this(javaType, lngClass, id.name());
        }

        @Override
        public String toString() {
            return this.declaration;
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.javaType, this.lngClass);
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Type type = (Type)obj;
            return Objects.equals(this.javaType, type.javaType) && Objects.equals(this.lngClass, type.lngClass);
        }
    }
}

