/*
 * Decompiled with CFR 0.152.
 */
package ch.turic.utils;

import ch.turic.ExecutionException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtils {
    public static boolean matches(String pattern, String text) {
        return StringUtils.matchHelper(pattern, 0, text, 0);
    }

    private static boolean matchHelper(String pattern, int pIdx, String text, int tIdx) {
        if (pIdx == pattern.length()) {
            return tIdx == text.length();
        }
        if (pattern.charAt(pIdx) == '*' && pattern.length() > pIdx + 1 && pattern.charAt(pIdx + 1) == '*') {
            for (int k = tIdx; k <= text.length(); ++k) {
                if (!StringUtils.matchHelper(pattern, pIdx + 2, text, k)) continue;
                return true;
            }
            return false;
        }
        if (pattern.charAt(pIdx) == '*') {
            for (int k = tIdx; k <= text.length(); ++k) {
                if (StringUtils.matchHelper(pattern, pIdx + 1, text, k)) {
                    return true;
                }
                if (k >= text.length() || text.charAt(k) != '/') continue;
                return false;
            }
            return false;
        }
        if (pattern.charAt(pIdx) == '?') {
            if (tIdx < text.length()) {
                return StringUtils.matchHelper(pattern, pIdx + 1, text, tIdx + 1);
            }
            return false;
        }
        if (pattern.charAt(pIdx) == '\\') {
            if (tIdx == text.length()) {
                return false;
            }
            ++tIdx;
        }
        if (tIdx < text.length() && pattern.charAt(pIdx) == text.charAt(tIdx)) {
            return StringUtils.matchHelper(pattern, pIdx + 1, text, tIdx + 1);
        }
        return false;
    }

    public static String digest(String input, String type) {
        try {
            MessageDigest md = MessageDigest.getInstance(type);
            byte[] digest = md.digest(input.getBytes(StandardCharsets.UTF_8));
            StringBuilder hexString = new StringBuilder();
            for (byte b : digest) {
                String hex = Integer.toHexString(0xFF & b);
                if (hex.length() == 1) {
                    hexString.append('0');
                }
                hexString.append(hex);
            }
            return hexString.toString();
        }
        catch (NoSuchAlgorithmException e) {
            throw new ExecutionException(e);
        }
    }

    public static String swapCase(String input) {
        int charCount;
        if (input == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(input.length());
        for (int i = 0; i < input.length(); i += charCount) {
            int cp = input.codePointAt(i);
            charCount = Character.charCount(cp);
            if (Character.isUpperCase(cp)) {
                sb.appendCodePoint(Character.toLowerCase(cp));
                continue;
            }
            if (Character.isLowerCase(cp)) {
                sb.appendCodePoint(Character.toUpperCase(cp));
                continue;
            }
            sb.appendCodePoint(cp);
        }
        return sb.toString();
    }

    public static String toTitleCase(String input) {
        if (input == null || input.isEmpty()) {
            return input;
        }
        StringBuilder titleCase = new StringBuilder();
        boolean nextTitle = true;
        for (char c : input.toCharArray()) {
            if (Character.isWhitespace(c)) {
                nextTitle = true;
                titleCase.append(c);
                continue;
            }
            if (nextTitle) {
                titleCase.append(Character.toTitleCase(c));
                nextTitle = false;
                continue;
            }
            titleCase.append(Character.toLowerCase(c));
        }
        return titleCase.toString();
    }

    public static String[] partition(String input, String sep) {
        if (input == null || sep == null || sep.isEmpty()) {
            throw new IllegalArgumentException("Input and separator must be non-null and separator non-empty.");
        }
        int index = input.indexOf(sep);
        if (index == -1) {
            return new String[]{input, "", ""};
        }
        String before = input.substring(0, index);
        String after = input.substring(index + sep.length());
        return new String[]{before, sep, after};
    }

    public static String[] partitionRegex(String input, String regex) throws ExecutionException {
        if (input == null || regex == null || regex.isEmpty()) {
            throw new IllegalArgumentException("Input and regex must be non-null and regex non-empty.");
        }
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(input);
        if (matcher.find()) {
            int start = matcher.start();
            int end = matcher.end();
            if (end == 0) {
                throw new ExecutionException("Partition regexp matches zero string. '" + regex + "' It is forbidden to avoid infinite loops.", new Object[0]);
            }
            return new String[]{input.substring(0, start), input.substring(start, end), input.substring(end)};
        }
        return new String[]{input, "", ""};
    }
}

